/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.*;
import com.jniwrapper.win32.Handle;

/**
 * This class represents DIBSECTION structure.
 *
 * @author Serge Piletsky
 */
public class DibSection extends Structure
{
    private BitmapStructure _bitmap = new BitmapStructure();
    private BitmapInfoHeader _bitmapInfoHeader = new BitmapInfoHeader();
    private PrimitiveArray _bitFields = new PrimitiveArray(UInt32.class, 3);
    private Handle _selection = new Handle();
    private UInt16 _offset = new UInt16();

    public DibSection()
    {
        init(new Parameter[]{_bitmap, _bitmapInfoHeader, _bitFields, _selection, _offset});
    }

    public BitmapStructure getBitmap()
    {
        return _bitmap;
    }

    public BitmapInfoHeader getBitmapInfoHeader()
    {
        return _bitmapInfoHeader;
    }
}
