/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;

/**
 * This class represents LOGBRUSH structure.
 *
 * @author Andrew Kharchenko
 */
public class LogBrush extends Structure
{
    protected UInt _style = new UInt();
    protected ColorRef _color = new ColorRef();
    protected Int32 _hatch = new Int32();

    public LogBrush()
    {
        init(new Parameter[]{_style, _color, _hatch});
    }

    public void setStyle(UInt style)
    {
        setStyle(style.getValue());
    }

    public void setStyle(long style)
    {
        _style.setValue(style);
    }

    public void setColor(ColorRef color)
    {
        if (_style.getValue() == Brush.BrushStyle.HATCHED.getValue() ||
            _style.getValue() == Brush.BrushStyle.SOLID.getValue())
        {
            _color.setValue(color.getValue());
        }
        else
            throw new IllegalArgumentException("");
    }

    public void setHatch(Int32 hatch)
    {
        setHatch(hatch.getValue());
    }

    public void setHatch(long hatch)
    {
        _hatch.setValue(hatch);
    }
}
