/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt8;

/**
 * This class represents RGBQUAD structure.
 *
 * @author Serge Piletsky
 */
public class RGBQuad extends Structure
{
    private UInt8 _blue = new UInt8();
    private UInt8 _green = new UInt8();
    private UInt8 _red = new UInt8();
    private UInt8 _reserved = new UInt8();

    public RGBQuad()
    {
        init(new Parameter[]{_blue, _green, _red, _reserved});
        _reserved.setValue(0);
    }

    public long getBlue()
    {
        return _blue.getValue();
    }

    public void setBlue(long value)
    {
        _blue.setValue(value);
    }

    public long getGreen()
    {
        return _green.getValue();
    }

    public void setGreen(long value)
    {
        _green.setValue(value);
    }

    public long getRed()
    {
        return _red.getValue();
    }

    public void setRed(long value)
    {
        _red.setValue(value);
    }

    public int getRGB()
    {
        int result = (int)((getRed() << 16) | (getGreen() << 8) | getBlue());
        return result;
    }
}
