/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.FunctionName;

/**
 *
 * @author Alexander Evsukov
 */
public class MessageBox
{
    /**
     * Makes message box to display an OK button.
     */
    public static final int OK = 0x00000000;

    /**
     * Makes message box to display OK and Cancel buttons.
     */
    public static final int OKCANCEL = 0x00000001;

    /**
     * Makes message box to display Abort, Retry, and Ignore buttons.
     */
    public static final int ABORTRETRYIGNORE = 0x00000002;

    /**
     * Makes message box to display Yes, No, and Cancel buttons.
     */
    public static final int YESNOCANCEL = 0x00000003;

    /**
     * Makes message box to display Yes and No buttons.
     */
    public static final int YESNO = 0x00000004;

    /**
     * Makes message box to display Retry and Cancel buttons.
     */
    public static final int RETRYCANCEL = 0x00000005;

    /**
     * Indicates that a hand icon should be displayed on the message box.
     */
    public static final int ICONHAND = 0x00000010;

    /**
     * Makes message box to display a question mark.
     */
    public static final int ICONQUESTION = 0x00000020;

    /**
     * Makes message box to display an exclamation icon.
     */
    public static final int ICONEXCLAMATION = 0x00000030;

    /**
     * Makes message box to display an asterisk icon.
     */
    public static final int ICONASTERISK = 0x00000040;

    /**
     * Makes message box to display a stop icon.
     */
    public static final int ICONSTOP = ICONHAND;

    /**
     * Makes message box to display an error icon.
     */
    public static final int ICONERROR = ICONHAND;

    /**
     * Makes message box to display a warning icon.
     */
    public static final int ICONWARNING = ICONEXCLAMATION;

    /**
     * Makes message box to display information icond
     */
    public static final int ICONINFORMATION = ICONASTERISK;

    /* To indicate the default button, specify one of the following values */
    public static final int DEFBUTTON1 = 0x00000000;
    public static final int DEFBUTTON2 = 0x00000100;
    public static final int DEFBUTTON3 = 0x00000200;

    static final FunctionName FUNCTION_MESSAGE_BOX = new FunctionName("MessageBox");

    public static int show(Wnd hWnd, String title, String message, int flags)
    {
        final Function function = User32.getInstance().getFunction(FUNCTION_MESSAGE_BOX.toString());
        Int result = new Int();
        function.invoke(result, hWnd,
                User32.getInstance().stringParam(message),
                User32.getInstance().stringParam(title),
                new UInt(flags));
        return (int) result.getValue();
    }

    public static int show(String title, String message, int flags)
    {
        Wnd hWnd = new Wnd();
        return show(hWnd, title, message, flags);
    }

    public static void show(String title, String message)
    {
        show(title, message, 0);
    }
}
