/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.gdi.GdiObject;

/**
 * This class wraps functionality provided by user32 library.
 *
 * @author Alexander Evsukov
 */
public class User32 extends WinFunctionCache
{
    static final FunctionName FUNCTION_GET_MESSAGE = new FunctionName("GetMessage");
    static final String FUNCTION_TRANSLATE_MESSAGE = "TranslateMessage";
    static final FunctionName FUNCTION_DISPATCH_MESSAGE = new FunctionName("DispatchMessage");
    static final String FUNCTION_POST_QUIT_MESSAGE = "PostQuitMessage";
    static final String FUNCTION_CREATE_ELLIPRIC_RGN = "CreateEllipticRgn";
    static final FunctionName FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
    static final String FUNCTION_TRACK_MOUSE_EVENT = "TrackMouseEvent";

    private static User32 _instance;

    private User32()
    {
        super("user32");
        setUnicode(Kernel32.getInstance().isUnicode());
    }

    public static User32 getInstance()
    {
        if (_instance == null)
        {
            _instance = new User32();
        }

        return _instance;
    }

    public static void postQuitMessage(int exitCode)
    {
        final Function function = getInstance().getFunction(FUNCTION_POST_QUIT_MESSAGE);
        function.invoke(null, new Int(exitCode));
    }

    public static Handle loadResourceFromFile(String fileName, int resourceType)
    {
        return loadResourceFromFile(fileName, resourceType, 0, 0);
    }

    public static Handle loadResourceFromFile(String fileName, int resourceType, int width, int height)
    {
        final Function function = getInstance().getFunction(FUNCTION_LOAD_IMAGE.toString());
        final Handle result = new Handle();
        function.invoke(result, new Parameter[]
        {
            new Pointer(null, true),
            getInstance().stringParam(fileName),
            new UInt(resourceType),
            new Int(width),
            new Int(height),
            new UInt(GdiObject.ImageLoadParameters.SHARED | GdiObject.ImageLoadParameters.LOADFROMFILE)
        });
        if (result.isNull())
        {
            throw new LastErrorException("Failed to load resource.", true);
        }
        return result;
    }

    public static boolean trackMouseEvent(TrackMouseEvent event)
    {
        final Function function = getInstance().getFunction(FUNCTION_TRACK_MOUSE_EVENT);
        Bool result = new Bool();
        function.invoke(result, new Pointer(event));
        return result.getValue();
    }
}
