/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.*;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.ui.Wnd;

/**
 * This class represents BROWSEINFO structure (both Ansi and Unicode)
 *
 * @author Serge Piletsky
 */
class BIStructure extends Structure
{
    private Wnd _owner = new Wnd();
    private Pointer.Void _itemIDList;
    private ZeroTerminatedString _displayName = null;
    private ZeroTerminatedString _title = null;
    private UInt _flags = new UInt();
    private Parameter _callback = null;
    private Pointer _param = new Pointer(null, true);
    private Int _image = new Int();

    static final int MAX_PATH = 260;

    public BIStructure(Parameter callback, Pointer.Void root)
    {
        _callback = callback == null? new Pointer.Void():callback;
        _itemIDList = root;
        initStringParameters();
        init(new Parameter[]{_owner, _itemIDList, new Pointer(_displayName), new Pointer(_title), _flags, _callback, _param, _image});
    }

    private void initStringParameters()
    {
        final Kernel32 kernel32 = Kernel32.getInstance();
        _displayName = kernel32.stringParam("", MAX_PATH);
        _title = kernel32.stringParam();
    }

    public Wnd getOwner()
    {
        return _owner;
    }

    public void setOwner(Wnd owner)
    {
        _owner.setValue(owner.getValue());
    }

    public Pointer.Void getItemIDList()
    {
        return _itemIDList;
    }

    public String getDisplayName()
    {
        return _displayName.getValue();
    }

    public void setDisplayName(String displayName)
    {
        _displayName.setValue(displayName);
    }

    public String getTitle()
    {
        return _title.getValue();
    }

    public void setTitle(String title)
    {
        _title.setValue(title);
    }

    public long getFlags()
    {
        return _flags.getValue();
    }

    public void setFlags(long flags)
    {
        _flags.setValue(flags);
    }

    public Parameter getParam()
    {
        return _param.getReferencedObject();
    }

    public void setParam(Parameter value)
    {
        _param.setReferencedObject(value, false);
    }
}
