/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* PRePServlet: There are three methods of the servletrunner, which invoke the PRePServlet
*	       class: the init(), handle() and destroy() methods. 
*
*	       The init() method of the PRePServlet will initialize a new PRePMain, 
*	       a ConnectionPool and a SecurityHashtable.
*
*	       As soon as a request from the servletrunner arrives, the handle() method of the 
*	       PRePServlet is called. This method handles the request and does everything
*	       from setting the PrintWriter to the login and finally output of the PRePFile.
*	       It is build out of different methods which all work over the PRePHandler. The
*	       PRePHandler is unique - unlike the PRePMain which is given to the 
*	       PRePServlet at the beginning. It will be deleted after the handle() method
*	       finished.
*
*	       If the servletrunner closes, it calls the destroy() method of the PrePSerlvet 
*	       class which itself calls the destroy() method of the PRePHandler class.
*	       The ConnectionPool will be destroyed and its connection closed one for one.
*
* History: - Creation 03/22/99 nh (replaces the former InputServlet)
*
* Date: 03/22/99
*
* @author nh
* @version 2.0
*/

package com.delec.prep;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class PRePServlet extends HttpServlet
{
	public PRePHandler prepHandler;

	protected static final int SECURITY = 1;

	public void init(ServletConfig servletConfig) throws ServletException
	{
		super.init(servletConfig);
		prepHandler = provideHandler(SECURITY);
		getFile();
		prepHandler.createSecurityHashtable();
		prepHandler.setDatabaseConnection();
	}

	/**
	* Handles the GET request > forward to the handle method
	* 
	**/
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException
	{
		handle(req, res);
	}

	public void getFile()
	{
	    String strConfig = "config";
	    String strValue = getInitParameter(strConfig);
	    prepHandler.getFile(strValue);
	}

	/**
	* methods for the servlet config interface
	*/
        public ServletContext getServletContext() {
	    return getServletConfig().getServletContext();
	}

	public String getInitParameter(String strName)
	{
	    return getServletConfig().getInitParameter(strName);
	}

	/**
	* Handles the POST request > forward to the handle method
	* 
	**/
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException
	{
		handle(req, res);
	}

	public void handle(HttpServletRequest req, HttpServletResponse res)
	{
		PRePMain prepMain = getPRePMain();
		Instance instance = new Instance(prepMain, req, res);

		setPrintWriter(instance);
		putPRePTags(instance);
		setParams(instance);
		setCookies(instance);
		setContext(instance);
		checkReload(instance);
		//prepMain.getSession().getTagList().outTag();

		boolean bLoginOk = checkCookie(instance);               
		getNewCookies(instance);

		if ( bLoginOk )
		{
			loginOk(instance);
		}
		else
		{
			loginNotOk(instance);
		}

		finishHandle(instance);
	}

	public void destroy()
	{
		prepHandler.destroy();
	}

	public PRePHandler provideHandler(int iSecurity)
	{
		return new PRePHandler(iSecurity);
	}


	public PRePMain getPRePMain()
	{
		return prepHandler.getPRePMain();
	}

	public void setPrintWriter(Instance instance)
	{
		try
		{
			PrintWriter pWriter = instance.getHttpServletResponse().getWriter();
			prepHandler.setPrintWriter(pWriter, instance.getPRePMain());
		}
		catch ( IOException e )
		{
		}
	}

	public void putPRePTags(Instance instance)
	{
		prepHandler.putPRePTags(instance.getPRePMain());
	}

	public void setParams(Instance instance)
	{
		HttpServletResponse res = instance.getHttpServletResponse();
		HttpServletRequest req = instance.getHttpServletRequest();
		PRePMain prepMain = instance.getPRePMain();

		Enumeration values = req.getParameterNames();
		PrintWriter pWriter = null;
		String name;
		String value = "";  

		while ( values.hasMoreElements() )
		{
			name = (String)values.nextElement();
			name = filterBrackets(name);
			if ( name != null )
			{
				for ( int i = 0; i < req.getParameterValues(name).length; i++ )
				{
					value = req.getParameterValues(name)[i];
					value = filterBrackets(value);

					if ( name.compareTo("submit") != 0 && value != null )
					{
						prepHandler.putField(prepMain, name, value);    
					}
				}
			}
		}
	}


	protected String filterBrackets(String strText)
	{
		if ( strText.indexOf("{") != -1 ||
			 strText.indexOf("}") != -1 )
		{

			return null;
		}
		else
		{
			return strText;
		}
	}

	public void setCookies(Instance instance)
	{
		HttpServletRequest req = instance.getHttpServletRequest();
		Cookie[] cookie = req.getCookies();
		String strUserInfo = null;

		// put all cookies on the prep stack /////////////////////////////////////////

		if ( cookie == null )
		{
			// no cookies
			return;
		}

		String strName;
		String strValue;

		for ( int i = 0; i < cookie.length; i++ )
		{
			strName = cookie[i].getName();
			strValue = cookie[i].getValue();

			if ( strName.equals("UINFO") )
			{
				strUserInfo = strValue;
			}

			strName = filterBrackets(strName);
			strValue = filterBrackets(strValue);

			if ( strName != null && strValue != null )
			{
				instance.getPRePMain().putField(strName, strValue);
			}
		}
	}

	public void checkReload(Instance instance)
	{
		prepHandler.checkReload(instance.getPRePMain());
	}

	public void setContext(Instance instance)
	{
		instance.getHttpServletResponse().setContentType("text/html");
	}

	public boolean checkCookie(Instance instance)
	{
		return prepHandler.checkCookie(instance.getPRePMain());
	}

	public void getNewCookies(Instance instance)
	{
		Object[] objCookies = prepHandler.getNewCookies(instance.getPRePMain());

		if ( objCookies != null )
		{

			for ( int i = 0; i < objCookies.length; i++ )
			{
				Cookie cookie = (Cookie)objCookies[i];

				if ( cookie != null )
				{
					instance.getHttpServletResponse().addCookie(cookie);
				}
			}
		}
	}

	public void loginOk(Instance instance)
	{
		prepHandler.loginOk(instance.getPRePMain());
	}

	public void loginNotOk(Instance instance)
	{
		prepHandler.loginNotOk(instance.getPRePMain());
	}

	public void finishHandle(Instance instance)
	{
		prepHandler.finishHandle(instance.getPRePMain());
	}

	public class Instance
	{
		PRePMain prepMain;
		HttpServletRequest req;
		HttpServletResponse res;

		public Instance(PRePMain prepMain, HttpServletRequest req, HttpServletResponse res)
		{
			this.prepMain = prepMain;
			this.req = req;
			this.res = res;
		}

		public PRePMain getPRePMain()
		{
			return prepMain;
		}

		public HttpServletRequest getHttpServletRequest()
		{
			return req;
		}

		public HttpServletResponse getHttpServletResponse()
		{
			return res;
		}
	}

}
