/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagCALCULATE: this tag can add, substract, divide, multiply, calculate the mod and
 *                   the power of two arguments which are floats
 *
 * History: - Creation 02/12/99 nh
 *
 * Date: 02/12/99
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

public class PRePTagCALCULATE extends PRePTagCode
{

	public PRePTagCALCULATE()
	{
		super("CALCULATE");
	}

	public void compile(Session session)
	{
		TagList tagList = session.getTagList();

		PRePTagCount prepTagCount = (PRePTagCount)tagList.find("ARG0");

		if ( prepTagCount != null )
		{
			int iArgs = prepTagCount.getIntValue();

			if ( iArgs >= 3 )
			{
				String strArg1 = tagList.find("ARG1").getValue();
				Float floatArg1 = null;
				float fArg1 = 0;

				char chSign = tagList.find("ARG2").getValue().charAt(0);

				String strArg2 = tagList.find("ARG3").getValue();
				Float floatArg2 = null;
				float fArg2 = 0;

				PRePTag prepTagOut = tagList.find("ARG4");
				//prepTagOut = tagList.find(prepTagOut.getValue());

				//if (prepTagOut != null)
				//{		

				int iTagListSize = tagList.size();

				try
				{
					floatArg1 = new Float(strArg1);
					floatArg2 = new Float(strArg2);
					fArg1 = floatArg1.floatValue();
					fArg2 = floatArg2.floatValue();
				}
				catch ( Exception e )
				{
					session.getExceptionList().addElement(new PRePException(this, "'float value not valid'"));
				}

				float fResult = 0;

				PRePTagObject prepTagObjResult = null;

				switch ( chSign )
				{
					
					case '+':
						fResult = fArg1 + fArg2;
						break;

					case '-':
						fResult = fArg1 - fArg2;
						break;

					case '*':
						fResult = fArg1 * fArg2;
						break;

					case '/':

						if ( fArg2 == 0 )
						{
							session.getExceptionList().addElement(new PRePException(this, "'division with 0'"));
						}
						else
						{
							fResult = fArg1 / fArg2;
						}
						break;

					case '^':

						double dResult = Math.pow((double)fArg1, (double)fArg2);
						prepTagObjResult = new PRePTagObject("RESULT");
						prepTagObjResult.setValue((float)dResult);
						break;

					case '%':
						fResult = fArg1 % fArg2;
						break;

				}

				if ( chSign != '^' )
				{
					prepTagObjResult = new PRePTagObject("RESULT");
					prepTagObjResult.setValue(fResult);
				}
				tagList.addElement(prepTagObjResult);
				if ( iArgs == 4 )
				{
					prepTagOut = tagList.find(prepTagOut.getValue());
					if ( prepTagOut != null )
					{
						prepTagOut.compile(session);
						tagList.setSize(iTagListSize);
					}
				}
				else
				{
					session.getPrintWriter().print(prepTagObjResult.getValue());
					session.getPrintWriter().flush();
				}
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));
			}

		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'no arguments'"));
		}
	}
}


