/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagDatabase: a superclass for all tags which use a database connection and have to
 *                  execute a SQL statement - it creates a store object which represents
 *                  the result
 *
 * History: - Creation 01/06/99 nh
 *
 * date: 01/06/99
 *
 * @author nh
 * @version 1.0
 */

package com.delec.prep;

import java.io.*;
import java.util.*;
import java.sql.*;

public class PRePTagDatabase extends PRePTagCode implements ExceptionHandler
{
	/**
	 * used for the Exception handling
	 */
	Session sessExp;

	public PRePTagDatabase()
	{
		super();
	}

	public PRePTagDatabase(String strName)
	{
		super(strName);
	}

	public SQLServe checkSQLServe(Session session)
	{
		SQLServe sqlServe = session.getSQLServe();
		if ( sqlServe == null )
		{
			sqlServe = new SQLServe();
			session.setSQLServe(sqlServe);
		}
		return sqlServe;
	}

	public Store executeSQL(String strSQLStatement, Session session)
	{
		sessExp = session;
		ExceptionHandler exceptionHandler = this;
		//SQLServe sqlServe = session.getSQLServe();

		SQLServe sqlServe = checkSQLServe(session);
		Store store = sqlServe.execStmtStore(strSQLStatement, session, exceptionHandler);
		return store;
	}

	public int executeUPDATE(String strSQLStatement, Session session)
	{
		sessExp = session;
		ExceptionHandler exceptionHandler = this;
		//SQLServe sqlServe = session.getSQLServe();

		SQLServe sqlServe = checkSQLServe(session);

		int iUpdate = sqlServe.execUpdate(strSQLStatement, session, exceptionHandler);

		return iUpdate;
	}

	public void handleException(Exception exception)
	{
		SQLServe sqlServe = sessExp.getSQLServe();

		String strException = exception.toString();

		if ( (strException.indexOf("server not found") != -1) || 
			 (strException.indexOf("link failure") != -1) ||
			 (strException.indexOf("broken") != -1) )
		{
			sqlServe.recoverConnection();
		}
		else
		{
			sessExp.getExceptionList().addElement(new PRePException(this, exception));
		}
	}
}   
