/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagFile: Defines a File 
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag, PRePTagText
 */
package com.delec.prep;
import java.io.*;
import java.util.*;

public class PRePTagFile extends PRePTagText
{

	/**
	 * Constructor
	 * @param String tag name
	 */
	public PRePTagFile(String sTagName)
	{
		super(sTagName);
	}

	/**
	 * Constructor
	 * @param String tag name
	 * @param TagList specified TagList
	 */
	public PRePTagFile(String sTagName, Session session)
	{
		super(sTagName);

		PrintWriter pwOld = session.getPrintWriter();

		StringWriter swriter = new StringWriter();
		session.setPrintWriter(new PrintWriter(swriter));
		session.getTagList().compile(this.sTagName, session);
		value = swriter.toString();
		value = value+".prep";

		session.setPrintWriter(pwOld);
	}

	/**
	 * gets the value of the tag
	 * @return value of the tag as a string
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * @param PrintWriter writer to compile the tag to
	 * @param TagList where the tags are stored
	 */              
	public void compile(Session session)
	{
		session.getPrintWriter().print(value);
	}
}
