package MSBMail;

import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class SmtpApplet extends Applet implements ActionListener, ProgressSMTPListener
{
	
	Label lblTo=new Label("To: ");
	TextField To= new TextField();
	Label lblCC=new Label("cc: ");
	Label lblStatus=new Label("");
	TextField CC= new TextField();
	Label lblBCC=new Label("bcc: ");
	TextField BCC= new TextField();
	Label lblSubject=new Label("Subject: ");	
	TextField Subject= new TextField();
	TextArea Body = new TextArea();
	RButton cmdClear= new RButton("clear.gif","Clear");
	RButton cmdSend= new RButton("send.gif","Send");
	//RButton cmdAttach= new RButton("attach.gif","Clear");
	//RButton cmdDelAttach= new RButton("delete.gif","Clear");
	java.awt.Checkbox sendPage = new Checkbox("Send this page as attachment",true);
	
	String smtpServer="";
	String smtpMyComputer="";
	String smtpMyemail="";
	String servletURL="";
	int sendCount=0;
	
	
	public void init() {
		
	  smtpServer=getStringParam("SMTP_SERVER",this.getCodeBase().getHost());
	  smtpMyemail=getStringParam("MY_MAIL","");
	  smtpMyComputer=getStringParam("MY_COMPUTER","127.0.0.1");
	  servletURL=getStringParam("RMAIL_SERVLET","");
	  
	  if (smtpServer.length()==0) smtpServer=this.getCodeBase().getHost();	  
	  if (smtpMyComputer.length()==0) smtpMyComputer="127.0.0.1";	  
	  
	  if (smtpServer.length()==0) smtpServer="127.0.0.1";
		
	  this.setSize(400,300);
				   
      this.setLayout(null);
	  
	  
	  // labels
	  lblTo.setBackground(java.awt.Color.lightGray);
	  lblCC.setBackground(java.awt.Color.lightGray);
	  lblBCC.setBackground(java.awt.Color.lightGray);
	  lblSubject.setBackground(java.awt.Color.lightGray);
	  lblStatus.setBackground(java.awt.Color.lightGray);
	  lblStatus.setForeground(java.awt.Color.blue);
	  lblStatus.setText("disconnected");
	  
	  lblTo.setBounds(10,10,60,20);
	  lblCC.setBounds(10,40,60,20);
	  lblBCC.setBounds(10,70,60,20);
	  lblSubject.setBounds(10,100,60,20);
	  lblStatus.setBounds(10,280,320,20);
	  
	  lblTo.setFont(new Font("Arial",Font.BOLD,12));
	  lblCC.setFont(new Font("Arial",Font.BOLD,12));
	  lblBCC.setFont(new Font("Arial",Font.BOLD,12));
	  lblSubject.setFont(new Font("Arial",Font.BOLD,12));
	  lblStatus.setFont(new Font("Arial",Font.PLAIN,10));
	  
	  this.add(lblTo);
	  this.add(lblCC);
      this.add(lblBCC);
	  this.add(lblSubject);
	  
	  // fields
	  
	  To.setBounds(70,10,270,20);
	  CC.setBounds(70,40,270,20);
	  BCC.setBounds(70,70,320,20);
	  Subject.setBounds(70,100,320,20);
	  Body.setBounds(10,140,380,120);
	  sendPage.setBounds(10,260,380,20);
	  
	    
	  To.setFont(new Font("Arial",Font.PLAIN,12));
	  CC.setFont(new Font("Arial",Font.PLAIN,12));
	  BCC.setFont(new Font("Arial",Font.PLAIN,12));
	  Subject.setFont(new Font("Arial",Font.PLAIN,12));	 
	  Body.setFont(new Font("Arial",Font.PLAIN,12));
	  sendPage.setFont(new Font("Arial",Font.PLAIN,12));
	  
	  this.add(To);
	  this.add(CC);
      this.add(BCC);
	  this.add(Subject);	  
	  this.add(Body);
	  this.add(sendPage);
	  this.add(lblStatus);
	  
	  // buttons
	  
	  cmdClear.setBounds(350,10,40,25);
	  cmdClear.setActionCommand("CLEAR");
	  cmdClear.addActionListener(this);
	  
	  cmdSend.setBounds(350,40,40,25);
	  cmdSend.setActionCommand("SEND");
	  cmdSend.addActionListener(this);


	  
	  this.add(cmdSend);

	  this.add(cmdClear);
	
	}
	
   // normalize a POST parameter	
   private String normalizeParam(String param) {
	    int p;
		
		// remove & from value 
		p=param.indexOf("&");
		while (p!=-1) {
			param=param.substring(0,p)+" "+param.substring(p+1,param.length());
			p=param.indexOf("&");
		}
		
		return param;
		
   }	
	
	private String[] splitAddress(String add) {
		String[] a=new String[100];
		int count=0;
		int p;
					   
	    p=add.indexOf(";");
		while (p>0) {
			if (add.substring(0,p).length()>0) a[count++]=add.substring(0,p);
			add=add.substring(p+1,add.length());
			p=add.indexOf(";");
		}
		
		if (add.length()>0) a[count++]=add;
		
		String[] result=new String[count];
		for (int i=0;i<count;i++) result[i]=a[i];
		
		return result;
	}
	
	public void progressText(String t) {
		 lblStatus.setText(t);
	}
	
	
	
	public void sendMsgViaServlet() {
	    // avoid spamming
		sendCount++;
		if (sendCount>3) lblStatus.setText("Reload page. More than 3 mails not allowed.");
				
		
	  try {
		  lblStatus.setText("Opening: "+servletURL);	  
		  
	   // connect to servlet	   
	   URL url = new URL(servletURL);
	   URLConnection connection = url.openConnection();
	   connection.setDoOutput(true);
	   
	  	lblStatus.setText("Posting to: "+servletURL);	 

	    PrintWriter out = new PrintWriter(
                              connection.getOutputStream());
		String requestStr;
	    requestStr="to=" + normalizeParam(To.getText())+"&";
		requestStr=requestStr+"cc=" + normalizeParam(CC.getText())+"&";
		requestStr=requestStr+"bcc=" + normalizeParam(BCC.getText())+"&";
		requestStr=requestStr+"subject=" + normalizeParam(Subject.getText())+"&";
		requestStr=requestStr+"body=" + normalizeParam(Body.getText())+"";
		if (sendPage.getState()) requestStr=requestStr+"&sendUrl=" + normalizeParam(this.getDocumentBase().toString());
	    out.println(requestStr);
		out.close();
		
		lblStatus.setText("Waiting for response: "+servletURL);	

		// read response from servlet
	    BufferedReader in = new BufferedReader(
				new InputStreamReader(
				connection.getInputStream()));
	     String inputLine;

	    while ((inputLine = in.readLine()) != null)
	       lblStatus.setText(inputLine);

	    in.close();
	
     } catch (Exception e) {lblStatus.setText(e.getMessage());}

	}
	
	
	public void sendMsg() {
		// avoid spamming
		sendCount++;
		if (sendCount>3) lblStatus.setText("Reload page. More than 3 mails not allowed.");
		
		
		MailMsg msg =new MailMsg();
		MailMsgPart attach= new MailMsgPart();
		MailMsgPart body= new MailMsgPart();
		
		msg.liste=this;
		
		msg.smtpServer=smtpServer;
		msg.smtpMyAddress=this.smtpMyComputer;
		msg.from=this.smtpMyemail;
		// to
		String[] to=splitAddress(To.getText());
		for (int i=0;i<to.length;i++) msg.addRecipient(to[i]);
		// bcc
		String[] bcc=splitAddress(BCC.getText());
		for (int i=0;i<bcc.length;i++) msg.addBCC(bcc[i]);
		// cc
		String[] cc=splitAddress(CC.getText());
		for (int i=0;i<cc.length;i++) msg.addCC(cc[i]);	
		
		msg.subject=Subject.getText();
		
		// add body
		body.setData(Body.getText(),MimeEncoder.NO_ENCODE);
		msg.addPart(body);
		
		// add html page as attachment
		if (sendPage.getState()) {
			
		  // try to laod the html page in a string
		   String htmlPage="";
		   
		   try { 
			   
		     // open URL
			 byte[] b=new byte[1]; 
		     InputStream IS = this.getDocumentBase().openStream();
		     while (IS.available()>0) {
			   IS.read(b); // read 1 byte at a time  
		       htmlPage=htmlPage+ ((char) b[0]);	   
		     }
		     IS.close();
		   
		     // create new part for the e mail message
		   
		    attach.ContentType="Text"; 
		    attach.ContentSubType="html"; // the new part will be html
		    attach.setData(htmlPage,MimeEncoder.NO_ENCODE);
		    msg.addPart(attach);	
		   }
		   catch (Exception e) {}
		   
		}
		
		
		if (msg.mail()!=0)lblStatus.setText("disconnected. "+lblStatus.getText());
		else lblStatus.setText("disconnected. OK");
	}
	
  private String getStringParam(String Param,String def) {

      return this.getParameter(Param, def);

    }


  //Get a parameter value
  public String getParameter(String key, String def) {
    if (getParameter(key) != null) return getParameter(key) ;
    else return def;
  }	
	
	public void actionPerformed(ActionEvent a) {
		String action=a.getActionCommand();
		
		
		if (action.compareTo("CLEAR")==0) {
			 To.setText("");
			 CC.setText("");
			 BCC.setText("");
			 Subject.setText("");
			 Body.setText("");
		}
		
		if (action.compareTo("SEND")==0) {
			 if (servletURL.length()==0) sendMsg();
			 else sendMsgViaServlet();
		}		
		
	}
	
}
