/*
 * Decompiled with CFR 0.152.
 */
import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.DataServer;
import cern.lhcias.csgui.interfaces.TagArrays;
import java.util.Vector;

public class MD2SDriver
implements Runnable,
DataServer {
    static String driverType = "MD2S";
    private String type = "";
    private Thread dataThread;
    private long sleepTime = -1L;
    private boolean active = false;
    private TagArrays c;
    private boolean mask = false;
    private String host;
    private int port;
    private long last_date;
    private int nb;
    Vector v = new Vector();
    Atom[] a = new Atom[1];
    private String processName = "";
    private boolean tagsSubscription = true;
    private static BCommManager MD2S_db = new BCommManager();

    public void addAlarmListener(AlarmListener alarmListener) {
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
    }

    public void setReadHost(String string) {
        this.host = string;
    }

    public String getReadHost() {
        return this.host;
    }

    public void setReadPort(int n) {
        this.port = n;
    }

    public int getReadPort() {
        return this.port;
    }

    public void setWriteHost(String string) {
    }

    public String getWriteHost() {
        return "";
    }

    public void setWritePort(int n) {
    }

    public int getWritePort() {
        return -1;
    }

    public void closeConnection() {
        MD2S_db.closeConnection();
    }

    public void setTagArrays(TagArrays tagArrays) {
        this.c = tagArrays;
    }

    public void setPoolingInterval(long l) {
        this.sleepTime = l;
    }

    public long getPoolingInterval() {
        return this.sleepTime;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setMask(boolean bl) {
        this.mask = bl;
    }

    public boolean getMask() {
        return this.mask;
    }

    public void setUser(String string) {
    }

    public void setPassword(String string) {
    }

    public String getUser() {
        return "";
    }

    public String getPassword() {
        return "";
    }

    public void setParameter(String string, String string2) {
    }

    public String getParameter(String string) {
        return "";
    }

    public void setTagsSubscription(boolean bl) {
        this.tagsSubscription = bl;
    }

    public boolean getTagsSubscription() {
        return this.tagsSubscription;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public String getProcessName() {
        return this.processName;
    }

    public boolean doYouImplement(String string) {
        return string.equalsIgnoreCase(driverType);
    }

    public Vector getPossibleProtocols() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(driverType);
        return vector;
    }

    public String getDriverProtocol() {
        return driverType;
    }

    public void setConfig(String string) {
        string = string.trim();
        try {
            this.setProcessName(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            string = string.substring(string.indexOf(59) + 1);
            this.setType(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setReadHost(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setReadPort(new Integer(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            this.setWriteHost(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setWritePort(new Integer(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            this.setPoolingInterval(new Double(string.substring(0, string.indexOf(59))).longValue());
            string = string.substring(string.indexOf(59) + 1);
            this.setTagsSubscription(new Boolean(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            Vector vector = MyUtils.getPropertiesinConfig(string, ';');
            int n = 0;
            while (n < vector.size() - 1) {
                this.setParameter((String)vector.elementAt(n), (String)vector.elementAt(n + 1));
                n += 2;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        String string = String.valueOf(this.processName) + ";" + this.getDriverProtocol() + ";" + this.getType() + ";" + this.getReadHost() + ";" + this.getReadPort() + ";" + this.getWriteHost() + ";" + this.getWritePort() + ";" + this.getPoolingInterval() + ";" + this.getTagsSubscription();
        return string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void disable() {
        if (this.active) {
            this.active = false;
            this.dataThread.stop();
        }
        MD2S_db.closeConnection();
    }

    public void enable() {
        if (!this.mask) {
            boolean bl = MD2S_db.isActive();
            if (!this.active && !bl) {
                MD2S_db.openConnection(this.host, this.port);
                bl = MD2S_db.isActive();
                if (bl && this.sleepTime > 0L) {
                    this.dataThread = new Thread(this);
                    this.dataThread.start();
                    this.active = true;
                }
            }
        }
    }

    public void write(String string, String string2) {
        if (!this.mask && MD2S_db.isActive()) {
            Atom atom = new Atom(string);
            atom.type = MD2S_db.getAtomType(atom);
            if (atom.type >= 0 && atom.type < 6) {
                switch (atom.type) {
                    case 0: {
                        if (string2.equalsIgnoreCase("true")) {
                            atom.booleanValue = true;
                            break;
                        }
                        if (string2.equalsIgnoreCase("false")) {
                            atom.booleanValue = false;
                            break;
                        }
                        double d = new Double(string2);
                        if (d != 0.0) {
                            atom.booleanValue = true;
                            break;
                        }
                        atom.booleanValue = false;
                        break;
                    }
                    case 1: {
                        atom.integerValue = new Short(string2);
                        break;
                    }
                    case 2: {
                        atom.longValue = new Integer(string2);
                        break;
                    }
                    case 3: {
                        atom.floatValue = new Float(string2).floatValue();
                        break;
                    }
                    case 4: {
                        atom.doubleValue = new Double(string2);
                        break;
                    }
                    case 5: {
                        atom.stringValue = string2;
                    }
                }
                MD2S_db.write(atom);
            }
        }
    }

    public void run() {
        while (this.active) {
            if (this.c.getNumberOfRemoteTags(this) > 0 && !this.mask) {
                this.get_from_server_MD2S();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public synchronized String read(String string) {
        if (this.mask) {
            return "";
        }
        String string2 = null;
        Atom atom = new Atom(string);
        if (MD2S_db.isActive()) {
            MD2S_db.read(atom);
            switch (atom.type) {
                case 0: {
                    if (atom.booleanValue) {
                        string2 = "1";
                        break;
                    }
                    string2 = "0";
                    break;
                }
                case 1: {
                    string2 = new Short(atom.integerValue).toString();
                    break;
                }
                case 2: {
                    string2 = new Integer(atom.longValue).toString();
                    break;
                }
                case 3: {
                    string2 = new Float(atom.floatValue).toString();
                    break;
                }
                case 4: {
                    string2 = new Double(atom.doubleValue).toString();
                    break;
                }
                case 5: {
                    string2 = atom.stringValue;
                }
            }
        }
        return string2;
    }

    public synchronized boolean read(Vector vector) {
        if (this.mask) {
            return true;
        }
        Vector<Atom> vector2 = new Vector<Atom>();
        Atom[] atomArray = new Atom[this.nb];
        if (MD2S_db.isActive()) {
            if (!this.c.beforeRefreshData()) {
                return false;
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                atomArray[n2] = new Atom((String)vector.elementAt(n2));
                atomArray[n2].type = MD2S_db.getAtomType(atomArray[n2]);
                vector2.addElement(atomArray[n2]);
                ++n2;
            }
            MD2S_db.readVector(vector2);
            n2 = 0;
            while (n2 < n) {
                switch (atomArray[n2].type) {
                    case 0: {
                        if (atomArray[n2].booleanValue) {
                            this.c.updateValue(atomArray[n2].name, "1");
                            break;
                        }
                        this.c.updateValue(atomArray[n2].name, "0");
                        break;
                    }
                    case 1: {
                        this.c.updateValue(atomArray[n2].name, new Short(atomArray[n2].integerValue).toString());
                        break;
                    }
                    case 2: {
                        this.c.updateValue(atomArray[n2].name, new Integer(atomArray[n2].longValue).toString());
                        break;
                    }
                    case 3: {
                        this.c.updateValue(atomArray[n2].name, new Float(atomArray[n2].floatValue).toString());
                        break;
                    }
                    case 4: {
                        this.c.updateValue(atomArray[n2].name, new Double(atomArray[n2].doubleValue).toString());
                        break;
                    }
                    case 5: {
                        this.c.updateValue(atomArray[n2].name, atomArray[n2].stringValue);
                    }
                }
                ++n2;
            }
            this.c.afterRefreshData();
            return true;
        }
        return false;
    }

    private synchronized boolean get_from_server_MD2S() {
        int n;
        if (!this.c.beforeRefreshData()) {
            return false;
        }
        long l = this.c.getDefinitionDate();
        if (l > this.last_date) {
            this.nb = this.c.getNumberOfRemoteTags(this);
            this.v = new Vector();
            this.a = new Atom[this.nb];
            Vector vector = this.c.getRemoteTagNames(this);
            n = 0;
            while (n < this.nb) {
                this.a[n] = new Atom((String)vector.elementAt(n));
                this.a[n].type = MD2S_db.getAtomType(this.a[n]);
                this.v.addElement(this.a[n]);
                ++n;
            }
            this.last_date = l;
        }
        MD2S_db.readVector(this.v);
        n = 0;
        while (n < this.nb) {
            switch (this.a[n].type) {
                case 0: {
                    if (this.a[n].booleanValue) {
                        this.c.updateValue(this.a[n].name, "1");
                        break;
                    }
                    this.c.updateValue(this.a[n].name, "0");
                    break;
                }
                case 1: {
                    this.c.updateValue(this.a[n].name, new Short(this.a[n].integerValue).toString());
                    break;
                }
                case 2: {
                    this.c.updateValue(this.a[n].name, new Integer(this.a[n].longValue).toString());
                    break;
                }
                case 3: {
                    this.c.updateValue(this.a[n].name, new Float(this.a[n].floatValue).toString());
                    break;
                }
                case 4: {
                    this.c.updateValue(this.a[n].name, new Double(this.a[n].doubleValue).toString());
                    break;
                }
                case 5: {
                    this.c.updateValue(this.a[n].name, this.a[n].stringValue);
                }
            }
            ++n;
        }
        this.c.afterRefreshData();
        return true;
    }
}

