/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.WinMgr;

import cern.lhcias.csgui.Events.TagClickedEvent;
import cern.lhcias.csgui.interfaces.TagClickedListener;
import cern.lhcias.csgui.interfaces.TagsView;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import symantec.itools.awt.TreeNode;
import symantec.itools.awt.TreeView;

public class ComponentsTreeView
extends TreeView
implements TagClickedListener {
    Vector ComponentsNodes;
    Vector myListeners = new Vector();

    public ComponentsTreeView() {
        this.setLayout(null);
        this.setBackground(new Color(0xFFFFFF));
        MyActionListener myActionListener = new MyActionListener();
        this.addActionListener(myActionListener);
    }

    public void createStructure(TagsView tagsView) {
        this.clear();
        this.ComponentsNodes = new Vector();
        this.appendComponent(tagsView, null);
        this.repaint();
    }

    public void setSelectedComponent(TagsView tagsView) {
        int n = this.ComponentsNodes.indexOf(tagsView);
        if (n > -1) {
            this.setSelectedNode((TreeNode)this.ComponentsNodes.elementAt(n + 1));
        }
    }

    public TagsView getSelectedComponent() {
        TreeNode treeNode = this.getSelectedNode();
        if (treeNode == null) {
            return null;
        }
        int n = this.ComponentsNodes.indexOf(treeNode);
        if (n == -1) {
            return null;
        }
        return (TagsView)this.ComponentsNodes.elementAt(n - 1);
    }

    void appendComponent(TagsView tagsView, TreeNode treeNode) {
        Vector vector;
        TreeNode treeNode2 = new TreeNode(tagsView.getType(), this);
        this.ComponentsNodes.addElement(tagsView);
        this.ComponentsNodes.addElement(treeNode2);
        if (treeNode == null) {
            this.append(treeNode2);
        } else {
            this.addChild(treeNode2, treeNode);
        }
        Vector vector2 = tagsView.getComponentsList();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                if ((TagsView)vector2.elementAt(n) != null) {
                    this.appendComponent((TagsView)vector2.elementAt(n), treeNode2);
                }
                ++n;
            }
        }
        if ((vector = tagsView.getLocalTagNames()) != null) {
            int n = 0;
            while (n < vector.size()) {
                if ((String)vector.elementAt(n) != null) {
                    this.addChild(new TreeNode((String)vector.elementAt(n)), treeNode2);
                }
                ++n;
            }
        }
    }

    public synchronized void addTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.addElement(tagClickedListener);
    }

    public synchronized void removeTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.removeElement(tagClickedListener);
    }

    void fireTagClickedEvent(Object object, String string, boolean bl) {
        TagClickedEvent tagClickedEvent = new TagClickedEvent(object);
        tagClickedEvent.setTagName(string);
        tagClickedEvent.setSentbyComponent(bl);
        int n = 0;
        while (n < this.myListeners.size()) {
            ((TagClickedListener)this.myListeners.elementAt(n)).receiveTagClicked(tagClickedEvent);
            ++n;
        }
    }

    public void receiveTagClicked(TagClickedEvent tagClickedEvent) {
        TagsView tagsView;
        if (tagClickedEvent.SentbyComponent && (tagsView = (TagsView)tagClickedEvent.getSource()) != null) {
            this.setSelectedComponent(tagsView);
        }
    }

    class MyActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TagsView tagsView = ComponentsTreeView.this.getSelectedComponent();
            String string = ComponentsTreeView.this.getSelectedText();
            if (tagsView != null) {
                ComponentsTreeView.this.fireTagClickedEvent(tagsView, string, true);
                return;
            }
            if (string != null) {
                ComponentsTreeView.this.fireTagClickedEvent(actionEvent.getSource(), string, false);
            }
        }

        MyActionListener() {
            ComponentsTreeView.this = ComponentsTreeView.this;
        }
    }
}

