/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import jclass.base.Border;
import jclass.base.TransientComponent;
import jclass.bwt.BWTUtil;
import jclass.bwt.ComboBoxConverter;
import jclass.bwt.ComboDialog;
import jclass.bwt.ComboField;
import jclass.bwt.ComboList;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCChoiceInterface;
import jclass.bwt.JCComboBoxEvent;
import jclass.bwt.JCComboBoxListener;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCItemSelectable;
import jclass.bwt.JCList;
import jclass.bwt.JCListComponent;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCListListener;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.bwt.JCTextManagerInterface;
import jclass.util.JCEnvironment;
import jclass.util.JCVector;

public class JCComboBox
extends JCContainer
implements JCListListener,
JCActionListener,
JCItemSelectable,
JCChoiceInterface,
JCTextInterface,
JCTextManagerInterface {
    public static final int COMBOBOX_SIMPLE = 0;
    public static final int COMBOBOX_DROPDOWN = 1;
    public static final int COMBOBOX_DROPDOWN_LIST = 2;
    ComboField text;
    ComboList list;
    JCArrowButton button;
    int style = 1;
    long list_popdown_time;
    long list_poppedup_time;
    protected boolean list_poppedup = false;
    boolean using_window = false;
    transient Window list_window;
    transient JCListEvent last_list_event;
    protected JCVector itemListeners = new JCVector(0);
    protected JCVector actionListeners = new JCVector(0);
    protected JCVector listeners = new JCVector(0);
    private static final String base = "combobox";
    private static int nameCounter;
    private static final boolean TRACE = false;
    protected static final int BEGIN = 0;
    protected static final int END = 1;
    static final int DEFAULT_VISIBLE_ROWS = 5;
    boolean visible_rows_set = false;
    transient int last_key = 32;

    public JCComboBox() {
        this((String[])null, (String)null);
    }

    public JCComboBox(JCVector jCVector) {
        this(jCVector, null, null);
    }

    public JCComboBox(String[] stringArray, String string) {
        this(new JCVector(stringArray), null, string);
    }

    public JCComboBox(JCVector jCVector, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.text = new ComboField(this);
        this.text.addActionListener(this);
        this.list = new ComboList(this);
        this.list.setAutoSelect(true);
        this.list.setVisibleRows(5);
        this.button = new JCArrowButton(9);
        this.button.setBorderThickness(2);
        this.button.right_border_color = Color.black;
        this.button.addActionListener(this);
        this.list.setItems(jCVector);
        this.list.addActionListener(this);
        this.list.addItemListener(this);
        this.setStyle(this.style);
        this.checkButton();
    }

    protected void getParameters() {
        super.getParameters();
        ComboBoxConverter.getParams(this);
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public JCTextInterface getTextComponent() {
        return this.text;
    }

    public JCList getList() {
        return this.list;
    }

    public JCArrowButton getButton() {
        return this.button;
    }

    public synchronized void setText(String string) {
        this.text.setText(string);
    }

    public synchronized String getText() {
        return this.text.getText();
    }

    public void setItems(String[] stringArray) {
        this.list.setItems(stringArray);
        this.checkButton();
    }

    public synchronized String[] getItems() {
        return this.list.getItemsStrings();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        ComboBoxConverter.checkStyle(n);
        if (this.style == 1) {
            this.hideList();
            this.list_window = null;
        }
        if (n != 1) {
            this.list.show();
        }
        this.style = n;
        this.text.setEditable(this.style != 2);
        this.text.setShowCursorPosition(this.style != 2);
        if (this.style == 0) {
            this.setInsets(new Insets(0, 0, 0, 0));
            this.text.setBorderThickness(2);
            this.list.getList().spacing = 0;
            this.list.getList().setBorderThickness(2);
        } else {
            this.setInsets(new Insets(2, 2, 2, 2));
            this.text.setBorderThickness(0);
            this.list.getList().spacing = -1;
            this.list.getList().setBorderThickness(0);
        }
        this.updateParent();
    }

    public int getItemCount() {
        return this.list.countItems();
    }

    public Object getItem(int n) {
        return this.list.getItem(n);
    }

    public void add(String string) {
        this.list.addItem(string);
    }

    public void remove(String string) {
        this.list.remove(string);
    }

    public void removeAll() {
        this.list.clear();
    }

    public String getSelectedItem() {
        Object object;
        ComboList comboList = this.list;
        synchronized (comboList) {
            object = this.list.getSelectedItem();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized void select(int n) {
        this.list.select(n);
    }

    public synchronized void select(Object object) {
        this.list.select(object);
    }

    public Object[] getSelectedObjects() {
        return this.list.getSelectedObjects();
    }

    public synchronized int[] getSelectedIndexes() {
        return this.list.getSelectedIndexes();
    }

    public void setVisibleRows(int n) {
        this.visible_rows_set = true;
        this.list.setVisibleRows(n);
    }

    public boolean getWrapAroundSearch() {
        return this.list.getWrapAroundSearch();
    }

    public void setWrapAroundSearch(boolean bl) {
        this.list.setWrapAroundSearch(bl);
    }

    public void addComboBoxListener(JCComboBoxListener jCComboBoxListener) {
        this.listeners.add(jCComboBoxListener);
    }

    public void removeComboBoxListener(JCComboBoxListener jCComboBoxListener) {
        this.listeners.removeElement(jCComboBoxListener);
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.add(jCItemListener);
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        this.itemListeners.removeElement(jCItemListener);
    }

    protected int preferredWidth() {
        int n = this.text.preferredSize().width + this.button.preferredSize().width;
        if (this.style != 0) {
            return n;
        }
        return Math.max(n, this.list.preferredSize().width);
    }

    protected int preferredHeight() {
        int n = this.text.preferredSize().height;
        if (this.style != 0) {
            return Math.max(n, this.button.preferredSize().height);
        }
        return n + this.list.preferredSize().height;
    }

    protected void setListProperties() {
        if (!this.list.bg_set) {
            this.list.getList().setBackground(this.text.getBackground());
            this.list.bg_set = false;
        }
        if (!this.list.fg_set) {
            this.list.getList().setForeground(this.text.getForeground());
            this.list.fg_set = false;
        }
        if (!this.list.fn_set) {
            this.list.getList().setFont(this.text.getFont());
            this.list.fn_set = false;
        }
    }

    public void addNotify() {
        this.add(this.text);
        this.add(this.button);
        if (this.style == 0) {
            this.add(this.list);
            this.setListProperties();
        }
        super.addNotify();
    }

    public void layout() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        JCComboBox jCComboBox = this;
        synchronized (jCComboBox) {
            n2 = this.button.preferredSize().width;
            n4 = n3 = this.text.preferredSize().height;
            n5 = this.insets().left + this.insets().right;
            n6 = this.insets().top + this.insets().bottom;
            n7 = Math.max(0, this.size().width - n5);
            n8 = Math.max(0, this.size().height - n6);
            n = this.style;
        }
        if (n == 0) {
            n4 = 0;
            n2 = 0;
            this.remove(this.button);
            int n9 = Math.max(n7, this.list.preferredSize().width);
            int n10 = Math.max(0, n8 - n3);
            int n11 = Math.min(0, n9 - n7);
            this.list.reshape(n11 + this.insets().left, n3 + this.insets().top, n9, n10);
            this.add(this.list);
            this.text.reshape(this.insets().left, this.insets().top, n7 - n2, n3);
            return;
        }
        this.remove(this.list);
        int n12 = Math.min(n8, n3 + 1);
        this.button.reshape(this.size().width - n2 - this.insets().right, this.insets().top, n2, n12 + 1);
        this.add(this.button);
        this.text.reshape(this.insets().left, this.insets().top, n7 - n2, n12 + 1);
    }

    public void showListAction(JCActionEvent jCActionEvent) {
        Frame frame;
        int n;
        if (this.style == 0) {
            return;
        }
        if (this.list_poppedup) {
            return;
        }
        this.postComboBoxEvent(0, null);
        int n2 = this.list.find(this.text.getText());
        if (n2 >= 0) {
            this.list.select(n2, false);
        } else {
            this.list.deselectAll();
        }
        Frame frame2 = this.text.getFrame();
        this.using_window = JCEnvironment.getAppletContext(this.applet) == null ? true : (JCEnvironment.isBrowserAppletViewer(this) ? true : JCEnvironment.isBrowserVisualAge(this));
        boolean bl = false;
        Window window = BWTUtil.getWindow(this);
        if (window instanceof Dialog) {
            bl = ((Dialog)window).isModal();
        }
        if (!this.using_window) {
            frame2.add(this.list, "Center", 0);
            this.list.addNotify();
        } else if (this.list_window == null || bl) {
            this.list_window = JCEnvironment.getOS() == 1 ? new ComboDialog(this, frame2) : new Window(frame2);
            this.list_window.add("Center", this.list);
            this.list_window.pack();
        }
        this.setListProperties();
        int n3 = Math.max(this.size().width, this.list.preferredSize().width);
        if (!this.visible_rows_set) {
            n = this.list.getItems().size();
            if (n == 0) {
                n = 1;
            } else if (n > 5) {
                n = 5;
            }
            this.list.setVisibleRows(n);
        }
        n = this.list.preferredSize().height;
        int n4 = Math.min(0, n3 - this.size().width);
        Window window2 = BWTUtil.getWindow(this.text);
        Point point = BWTUtil.translateToParent(window2, this, n4, this.text.location().y + this.text.size().height);
        Frame frame3 = frame = window2 instanceof Frame ? null : frame2;
        if (this.using_window || !JCEnvironment.isBrowserExplorer(this) || frame != null) {
            point = BWTUtil.translateToParent(frame, window2, point.x, point.y);
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        if (!this.using_window) {
            dimension = window2.size();
        }
        point.x = Math.max(0, Math.min(point.x, dimension.width - n3));
        point.y = Math.max(0, Math.min(point.y, dimension.height - n));
        if (!this.using_window) {
            this.list.reshape(point.x, point.y, n3, n);
        } else {
            ((Component)this.list_window).reshape(point.x, point.y, n3, n);
            this.list.resize(n3, n);
            this.list.show();
            this.list_window.show();
        }
        this.list.exited = true;
        this.list.makeVisible(this.list.getSelectedIndex());
        this.list.show();
        this.list.getList().requestFocus();
        this.list_poppedup = true;
    }

    void hideList() {
        if (!this.list_poppedup) {
            return;
        }
        TransientComponent.popdown_event_timestamp = TransientComponent.mouse_down_event_timestamp;
        this.list_popdown_time = System.currentTimeMillis();
        this.list_poppedup = false;
        if (this.style == 0) {
            return;
        }
        if (this.using_window && this.list_window != null) {
            ((Component)this.list_window).hide();
        } else if (!this.using_window) {
            this.list.hide();
        }
        if (this.last_list_event != null && this.last_list_event.event != null) {
            this.text.requestFocus();
        }
    }

    protected void setTextAction(String string) {
        JCComboBoxEvent jCComboBoxEvent = this.postComboBoxEvent(1, string);
        if (jCComboBoxEvent != null) {
            string = jCComboBoxEvent.value != null ? jCComboBoxEvent.value.toString() : null;
        }
        this.text.setText(string);
        if (this.itemListeners.size() == 0) {
            return;
        }
        JCItemEvent jCItemEvent = new JCItemEvent(this, 701, (Object)string, 1);
        int n = 0;
        while (n < this.itemListeners.size()) {
            JCItemListener jCItemListener = (JCItemListener)this.itemListeners.elementAt(n);
            jCItemListener.itemStateChanged(jCItemEvent);
            ++n;
        }
    }

    protected JCComboBoxEvent postComboBoxEvent(int n, Object object) {
        if (this.listeners.size() == 0) {
            return null;
        }
        JCComboBoxEvent jCComboBoxEvent = new JCComboBoxEvent((Object)this, object);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            JCComboBoxListener jCComboBoxListener = (JCComboBoxListener)this.listeners.elementAt(n2);
            if (n == 0) {
                jCComboBoxListener.comboBoxListDisplayBegin(jCComboBoxEvent);
            } else {
                jCComboBoxListener.comboBoxListDisplayEnd(jCComboBoxEvent);
            }
            ++n2;
        }
        return jCComboBoxEvent;
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
    }

    protected int getNextAutoSearchIndex(Event event, int n) {
        char c;
        int n2 = -999;
        int n3 = this.getSelectedIndex();
        JCListComponent jCListComponent = this.list.getList();
        int n4 = jCListComponent.getItems().size();
        char c2 = c = (char)(event.key == 1005 ? 32 : (char)n);
        if (n4 < 1) {
            return -999;
        }
        if (this.isEditable() && event.key != 1005 && !this.getText().equalsIgnoreCase(String.valueOf(c))) {
            return -999;
        }
        if (this.isEditable() && this.getText().length() == 1) {
            c = this.getText().charAt(0);
        }
        if (c == ' ') {
            n2 = Math.max(0, n3 + 1);
            if (this.getWrapAroundSearch() && n2 >= n4) {
                n2 = 0;
            }
            return n2;
        }
        if (n3 == -999 || this.last_key != n && event.key != 1005 || n3 != -999 && !this.getSelectedItem().equalsIgnoreCase(String.valueOf(c))) {
            n2 = jCListComponent.findItem(c);
        } else {
            if (n3 + 1 < n4) {
                n2 = jCListComponent.findNextItem(c, n3 + 1);
            }
            if (this.getWrapAroundSearch() && n2 == -999) {
                n2 = jCListComponent.findItem(c);
            }
        }
        return n2;
    }

    protected int getPrevAutoSearchIndex(Event event, int n) {
        char c;
        int n2 = -999;
        int n3 = this.getSelectedIndex();
        JCListComponent jCListComponent = this.list.getList();
        int n4 = jCListComponent.getItems().size();
        char c2 = c = (char)(event.key == 1004 ? 32 : (char)n);
        if (n4 < 1) {
            return -999;
        }
        if (this.isEditable() && event.key != 1004 && !this.getText().equalsIgnoreCase(String.valueOf(c))) {
            return -999;
        }
        if (this.isEditable() && this.getText().length() == 1) {
            c = this.getText().charAt(0);
        }
        if (c == ' ') {
            n2 = n3 - 1;
            if (this.getWrapAroundSearch() && n2 < 0) {
                n2 = n4 - 1;
            }
            return n2;
        }
        if (n3 == -999 || this.last_key != n && event.key != 1004 || n3 != -999 && !this.getSelectedItem().equalsIgnoreCase(String.valueOf(c))) {
            n2 = jCListComponent.findPrevItem(c, n4 - 1);
        } else {
            if (n3 - 1 < n4) {
                n2 = jCListComponent.findPrevItem(c, n3 - 1);
            }
            if (this.getWrapAroundSearch() && n2 == -999) {
                n2 = jCListComponent.findPrevItem(c, n4 - 1);
            }
        }
        return n2;
    }

    public boolean keyDown(Event event, int n) {
        if (event.target == this.text) {
            int n2 = -999;
            if (event.controlDown() && event.key == 1005) {
                this.showListAction(new JCActionEvent(this.text, event.id, null, event.modifiers));
                return true;
            }
            if (event.key == 1005) {
                n2 = this.getNextAutoSearchIndex(event, n);
            } else if (event.key == 1004) {
                n2 = this.getPrevAutoSearchIndex(event, n);
            } else {
                n2 = this.getNextAutoSearchIndex(event, n);
                this.last_key = n;
            }
            if (n2 != -999) {
                this.list.deselectAll();
                this.list.makeVisible(n2);
                if (!this.isEditable() || event.key == 1005 || event.key == 1004) {
                    this.list.select(n2);
                    this.list.getList().setFocus(n2);
                }
            }
        }
        return super.keyDown(event, n);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.button) {
            long l = System.currentTimeMillis() - this.list_popdown_time;
            if (!this.list_poppedup && l >= 0L && l < 150L) {
                return;
            }
            if (this.list_poppedup) {
                this.hideList();
                return;
            }
            this.list_poppedup_time = System.currentTimeMillis();
            this.showListAction(jCActionEvent);
            return;
        }
        if (jCActionEvent.getSource() == this.list) {
            this.setTextAction(this.getSelectedItem());
            this.hideList();
            return;
        }
        if (jCActionEvent.getSource() == this.text && this.actionListeners.size() > 0) {
            JCActionEvent jCActionEvent2 = new JCActionEvent(this, 1001, null);
            int n = 0;
            while (n < this.actionListeners.size()) {
                ((JCActionListener)this.actionListeners.elementAt(n)).actionPerformed(jCActionEvent2);
                ++n;
            }
        }
    }

    public void listItemSelectBegin(JCListEvent jCListEvent) {
    }

    public void listItemSelectEnd(JCListEvent jCListEvent) {
        this.last_list_event = jCListEvent;
        if (jCListEvent.getStateChange() != 1) {
            return;
        }
        if (jCListEvent.event == null || jCListEvent.event.id == 501) {
            this.setTextAction(this.getSelectedItem());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void paintInterior(Graphics graphics) {
        if (this.style == 0) {
            return;
        }
        Color color = this.getBackground();
        Border.draw(graphics, 3, 1, 0, 0, this.size().width, this.size().height, color == Color.lightGray ? Color.white : Border.brighter(color), BWTUtil.darker(color), null);
        Border.draw(graphics, 3, 1, 1, 1, this.size().width - 2, this.size().height - 2, color.brighter().darker(), Color.black, null);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.text.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.text.removeKeyListener(keyListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.text.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.text.removeFocusListener(focusListener);
    }

    public String getSelectedText() {
        return this.text.getSelectedText();
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
    }

    public int getSelectionStart() {
        return this.text.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.text.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.text.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.text.setSelectionEnd(n);
    }

    public void select(int n, int n2) {
        this.text.select(n, n2);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void insert(String string, int n) {
        this.text.insert(string, n);
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void replaceRange(String string, int n, int n2) {
        this.text.replaceRange(string, n, n2);
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public void setColumns(int n) {
        this.text.setColumns(n);
    }

    public int getAlignment() {
        return this.text.getAlignment();
    }

    public void setAlignment(int n) {
        this.text.setAlignment(n);
    }

    public int getMaximumLength() {
        return this.text.getMaximumLength();
    }

    public void setMaximumLength(int n) {
        this.text.setMaximumLength(n);
    }

    public int getStringCase() {
        return this.text.getStringCase();
    }

    public void setStringCase(int n) {
        this.text.setStringCase(n);
    }

    public void beep() {
        this.text.beep();
    }

    public boolean getChanged() {
        return this.text.getChanged();
    }

    public void setChanged(boolean bl) {
        this.text.setChanged(bl);
    }

    public Dimension getMinimumSize(int n) {
        return this.text.getMinimumSize(n);
    }

    public int[] getSelectionList() {
        return this.text.getSelectionList();
    }

    public void setSelectionList(int[] nArray) {
        this.text.setSelectionList(nArray);
    }

    public Color getSelectedBackground() {
        return this.text.getSelectedBackground();
    }

    public void setSelectedBackground(Color color) {
        this.text.setSelectedBackground(color);
    }

    public Color getSelectedForeground() {
        return this.text.getSelectedForeground();
    }

    public void setSelectedForeground(Color color) {
        this.text.setSelectedForeground(color);
    }

    public int pointToPosition(int n, int n2) {
        return this.text.pointToPosition(n, n2);
    }

    public void showPosition(int n) {
        this.text.showPosition(n);
    }

    public int getCursorPosition() {
        return this.text.getCursorPosition();
    }

    public void setCursorPosition(int n) {
        this.text.setCursorPosition(n);
    }

    public void setOverstrike(boolean bl) {
        this.text.setOverstrike(bl);
    }

    public boolean getOverstrike() {
        return this.text.getOverstrike();
    }

    public int getLastPosition() {
        return this.text.getLastPosition();
    }

    public boolean getShowCursorPosition() {
        return this.text.getShowCursorPosition();
    }

    public void setShowCursorPosition(boolean bl) {
        this.text.setShowCursorPosition(bl);
    }

    public void addTextListener(JCTextListener jCTextListener) {
        this.text.addTextListener(jCTextListener);
    }

    public void removeTextListener(JCTextListener jCTextListener) {
        this.text.removeTextListener(jCTextListener);
    }

    public void addTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.addTextCursorListener(jCTextCursorListener);
    }

    public void removeTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.removeTextCursorListener(jCTextCursorListener);
    }

    public int getShadowThickness() {
        return this.text.getBorderThickness();
    }

    public void setShadowThickness(int n) {
        this.text.setBorderThickness(n);
    }

    public int getHighlightThickness() {
        return this.text.getHighlightThickness();
    }

    public void setHighlightThickness(int n) {
        this.text.setHighlightThickness(n);
    }

    public Color getHighlightColor() {
        return this.text.getHighlightColor();
    }

    public void setHighlightColor(Color color) {
        this.text.setHighlightColor(color);
    }

    public void checkButton() {
        if (this.button == null) {
            return;
        }
        if (this.list.countItems() > 0) {
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
                return;
            }
        } else if (this.button.isEnabled()) {
            this.button.setEnabled(false);
        }
    }
}

