/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.JCChart;
import jclass.chart.JCLegend;
import jclass.chart.JCLegendItem;
import jclass.util.JCString;
import jclass.util.JCVector;

public class JCGridLegend
extends JCLegend {
    public int[] rowHeights;
    public int[] rowFirstLineHeights;
    public int[] colWidths;
    public int[] symWidths;
    public int[] strWidths;
    int marginGap = 2;
    int itemGap = 2;
    int insideItemGap = 2;
    int groupGap = 5;

    public void setMarginGap(int n) {
        JCGridLegend jCGridLegend = this;
        synchronized (jCGridLegend) {
            this.marginGap = n;
        }
        this.setChanged(true, 2);
    }

    public int getMarginGap() {
        return this.marginGap;
    }

    public void setItemGap(int n) {
        JCGridLegend jCGridLegend = this;
        synchronized (jCGridLegend) {
            this.itemGap = n;
        }
        this.setChanged(true, 2);
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setInsideItemGap(int n) {
        JCGridLegend jCGridLegend = this;
        synchronized (jCGridLegend) {
            this.insideItemGap = n;
        }
        this.setChanged(true, 2);
    }

    public int getInsideItemGap() {
        return this.insideItemGap;
    }

    public void setGroupGap(int n) {
        JCGridLegend jCGridLegend = this;
        synchronized (jCGridLegend) {
            this.groupGap = n;
        }
        this.setChanged(true, 2);
    }

    public int getGroupGap() {
        return this.groupGap;
    }

    public Dimension layoutLegend(JCVector jCVector, boolean bl, Font font) {
        this.fillSizeArrays(jCVector, bl, font);
        Dimension dimension = this.calcLegendSize(bl);
        this.layoutLegendItems(jCVector, bl);
        return dimension;
    }

    public void fillSizeArrays(JCVector jCVector, boolean bl, Font font) {
        int n;
        JCChart jCChart = this.getParent();
        int n2 = jCVector.size();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = Math.max(n3, ((JCVector)jCVector.elementAt(n4)).size());
            ++n4;
        }
        this.rowHeights = new int[bl ? n3 : n2];
        int n5 = 0;
        while (n5 < this.rowHeights.length) {
            this.rowHeights[n5] = 0;
            ++n5;
        }
        this.rowFirstLineHeights = new int[bl ? n3 : n2];
        int n6 = 0;
        while (n6 < this.rowFirstLineHeights.length) {
            this.rowFirstLineHeights[n6] = 0;
            ++n6;
        }
        this.colWidths = new int[bl ? n2 : n3];
        int n7 = 0;
        while (n7 < this.colWidths.length) {
            this.colWidths[n7] = 0;
            ++n7;
        }
        this.symWidths = new int[bl ? n2 : n3];
        int n8 = 0;
        while (n8 < this.symWidths.length) {
            this.symWidths[n8] = 0;
            ++n8;
        }
        this.strWidths = new int[bl ? n2 : n3];
        int n9 = 0;
        while (n9 < this.strWidths.length) {
            this.strWidths[n9] = 0;
            ++n9;
        }
        int n10 = 0;
        while (n10 < n2) {
            JCVector jCVector2 = (JCVector)jCVector.elementAt(n10);
            n = 0;
            while (n < jCVector2.size()) {
                JCLegendItem jCLegendItem = (JCLegendItem)jCVector2.elementAt(n);
                Dimension dimension = null;
                if (jCLegendItem.contents instanceof JCString) {
                    dimension = new Dimension(0, 0);
                    ((JCString)jCLegendItem.contents).getLineSize(jCChart, font, 0, dimension);
                    dimension.height -= this.descent;
                } else if (jCLegendItem.contents instanceof String) {
                    if (jCLegendItem.textDim != null) {
                        dimension = new Dimension(jCLegendItem.textDim.width, this.ascent);
                    }
                } else if (jCLegendItem.textDim != null) {
                    dimension = new Dimension(jCLegendItem.textDim.width, jCLegendItem.textDim.height);
                }
                if (bl) {
                    if (this.isTitleItem(jCLegendItem)) {
                        if (jCLegendItem.textDim != null && this.colWidths[n10] < jCLegendItem.textDim.width) {
                            this.colWidths[n10] = jCLegendItem.textDim.width;
                        }
                    } else {
                        if (jCLegendItem.symbolDim != null && this.symWidths[n10] < jCLegendItem.symbolDim.width) {
                            this.symWidths[n10] = jCLegendItem.symbolDim.width;
                        }
                        if (jCLegendItem.textDim != null && this.strWidths[n10] < jCLegendItem.textDim.width) {
                            this.strWidths[n10] = jCLegendItem.textDim.width;
                        }
                    }
                    if (jCLegendItem.symbolDim != null && this.rowHeights[n] < jCLegendItem.symbolDim.height) {
                        this.rowHeights[n] = jCLegendItem.symbolDim.height;
                    }
                    if (jCLegendItem.textDim != null && this.rowHeights[n] < jCLegendItem.textDim.height) {
                        this.rowHeights[n] = jCLegendItem.textDim.height;
                    }
                    if (dimension != null && this.rowFirstLineHeights[n] < dimension.height) {
                        this.rowFirstLineHeights[n] = dimension.height;
                    }
                } else {
                    if (jCLegendItem.symbolDim != null && this.rowHeights[n10] < jCLegendItem.symbolDim.height) {
                        this.rowHeights[n10] = jCLegendItem.symbolDim.height;
                    }
                    if (jCLegendItem.textDim != null && this.rowHeights[n10] < jCLegendItem.textDim.height) {
                        this.rowHeights[n10] = jCLegendItem.textDim.height;
                    }
                    if (dimension != null && this.rowFirstLineHeights[n10] < dimension.height) {
                        this.rowFirstLineHeights[n10] = dimension.height;
                    }
                    if (jCLegendItem.symbolDim != null && this.symWidths[n] < jCLegendItem.symbolDim.width) {
                        this.symWidths[n] = jCLegendItem.symbolDim.width;
                    }
                    if (jCLegendItem.textDim != null && this.strWidths[n] < jCLegendItem.textDim.width) {
                        this.strWidths[n] = jCLegendItem.textDim.width;
                    }
                }
                ++n;
            }
            ++n10;
        }
        int n11 = 0;
        while (n11 < this.colWidths.length) {
            n = this.symWidths[n11] + this.strWidths[n11];
            if (this.symWidths[n11] != 0 && this.strWidths[n11] != 0) {
                n += this.getInsideItemGap();
            }
            if (this.colWidths[n11] < n) {
                this.colWidths[n11] = n;
            }
            ++n11;
        }
    }

    public Dimension calcLegendSize(boolean bl) {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < this.colWidths.length) {
            dimension.width += this.colWidths[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.rowHeights.length) {
            dimension.height += this.rowHeights[n2];
            ++n2;
        }
        if (bl) {
            dimension.width += (this.colWidths.length - 1) * this.getGroupGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getItemGap();
            dimension.height += 2 * this.getMarginGap();
        } else {
            dimension.width += (this.colWidths.length - 1) * this.getItemGap();
            dimension.width += 2 * this.getMarginGap();
            dimension.height += (this.rowHeights.length - 1) * this.getGroupGap();
            dimension.height += 2 * this.getMarginGap();
        }
        return dimension;
    }

    public void layoutLegendItems(JCVector jCVector, boolean bl) {
        int n = this.getMarginGap();
        int n2 = 0;
        while (n2 < jCVector.size()) {
            JCVector jCVector2 = (JCVector)jCVector.elementAt(n2);
            int n3 = this.getMarginGap();
            int n4 = 0;
            while (n4 < jCVector2.size()) {
                JCLegendItem jCLegendItem = (JCLegendItem)jCVector2.elementAt(n4);
                jCLegendItem.pos = new Point(bl ? n : n3, bl ? n3 : n);
                jCLegendItem.dim = new Dimension(bl ? this.colWidths[n2] : this.colWidths[n4], bl ? this.rowHeights[n4] : this.rowHeights[n2]);
                if (this.isTitleItem(jCLegendItem)) {
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, jCLegendItem.dim, new Point(0, 0));
                } else {
                    jCLegendItem.symbolPos = this.positionItemSymbol(bl, jCLegendItem, new Dimension(0, bl ? this.rowFirstLineHeights[n4] : this.rowFirstLineHeights[n2]), new Point(0, 0));
                    jCLegendItem.textPos = this.positionItemText(bl, jCLegendItem, new Dimension(0, bl ? this.rowFirstLineHeights[n4] : this.rowFirstLineHeights[n2]), new Point(this.getInsideItemGap() + (bl ? this.symWidths[n2] : this.symWidths[n4]), 0));
                }
                jCLegendItem.pickRectangle = new Rectangle(jCLegendItem.pos.x, jCLegendItem.pos.y, jCLegendItem.dim.width, jCLegendItem.dim.height);
                if (n4 != jCVector2.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.height += this.getItemGap();
                    } else {
                        jCLegendItem.pickRectangle.width += this.getItemGap();
                    }
                }
                if (n2 != jCVector.size() - 1) {
                    if (bl) {
                        jCLegendItem.pickRectangle.width += this.getGroupGap();
                    } else {
                        jCLegendItem.pickRectangle.height += this.getGroupGap();
                    }
                }
                n3 += (bl ? this.rowHeights[n4] : this.colWidths[n4]) + this.getItemGap();
                ++n4;
            }
            n += (bl ? this.colWidths[n2] : this.rowHeights[n2]) + this.getGroupGap();
            ++n2;
        }
    }

    public Point positionItemSymbol(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.symbolDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.symbolDim, jCLegendItem.dim.height, point);
    }

    public Point positionItemText(boolean bl, JCLegendItem jCLegendItem, Dimension dimension, Point point) {
        if (bl) {
            if (jCLegendItem.textDim.height < dimension.height) {
                return this.centerItemComponentVertically(bl, jCLegendItem.textDim, dimension.height, point);
            }
            return point;
        }
        return this.centerItemComponentVertically(bl, jCLegendItem.textDim, jCLegendItem.dim.height, point);
    }

    Point centerItemComponentVertically(boolean bl, Dimension dimension, int n, Point point) {
        Point point2 = new Point(point.x, point.y);
        if (n - point.y > dimension.height) {
            point2.y += (int)Math.ceil((double)(n - point.y - dimension.height) / 2.0);
        }
        return point2;
    }
}

