/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.chart.JCChartBundle;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;

public class RadioButtonImageEditor
extends JCContainer
implements PropertyEditor,
JCItemListener {
    int selectedValue;
    transient Image[] images;
    String[] strings;
    int[] values;
    String prepend = "";
    int rows;
    int cols;
    int numImages;
    boolean upperCaseEnum = true;
    JCCheckboxGroup orientBox;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void init(int n, String[] stringArray, int[] nArray, Image[] imageArray, int n2, int n3, String string) {
        this.numImages = n;
        this.strings = stringArray;
        this.values = nArray;
        this.images = imageArray;
        this.rows = n2;
        this.cols = n3;
        this.prepend = string;
        this.init();
    }

    protected void init() {
        this.setLayout(new GridLayout(1, 1));
        this.setInsets(new Insets(2, 4, 2, 2));
        Object[] objectArray = new Object[this.numImages];
        int n = 0;
        while (n < this.numImages) {
            JCString jCString = new JCString("");
            jCString.add(this.images[n]);
            objectArray[n] = jCString;
            ++n;
        }
        this.orientBox = JCCheckbox.makeGroup(objectArray, this.values, true);
        this.orientBox.setTitle("Axis Orientation");
        this.orientBox.setLayout(new GridLayout(this.rows, this.cols));
        this.orientBox.addItemListener(this);
        this.add(this.orientBox);
    }

    public void setValue(Object object) {
        this.setSelectedValue(((Number)object).intValue(), true);
    }

    protected void setSelectedValue(int n, boolean bl) {
        this.selectedValue = n;
        if (bl) {
            this.orientBox.setValue(n);
        }
        this.support.firePropertyChange("", null, null);
    }

    public Object getValue() {
        return new Integer(this.selectedValue);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return null;
    }

    public String[] getTags() {
        return null;
    }

    protected String getValueAsText() {
        return JCUtilConverter.fromEnum(this.selectedValue, this.strings, this.values);
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        if (this.upperCaseEnum) {
            return String.valueOf(this.prepend) + this.getValueAsText().toUpperCase();
        }
        return String.valueOf(this.prepend) + this.getValueAsText();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            boolean bl;
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null) {
                return;
            }
            boolean bl2 = bl = jCCheckbox.getState() != 0;
            if (!bl) {
                return;
            }
            if (jCCheckbox.getCheckboxGroup() == this.orientBox) {
                this.setSelectedValue(jCCheckbox.getUserDataInt(), false);
            }
        }
    }
}

