/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnList;
import jclass.chart.EventTrigger;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.JCEnumEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;
import jclass.util.JCVector;

public class ChartTriggerPage
extends JCPropertyPage
implements JCActionListener,
JCItemListener {
    private JCMultiColumnList triggerList;
    private JCEnumEditor actionField;
    private JCEnumEditor modifierField;
    private JCButton addTriggerButton;
    private JCButton removeTriggerButton;
    JCChart target;
    static final String[] valueLabel_columns = new String[]{"Trigger   ", "Modifier       "};

    public void init() {
        this.setLayout(new JCGridLayout(1, 2));
        this.triggerList = new JCMultiColumnList();
        this.triggerList.setNumColumns(2);
        this.triggerList.setColumnButtons(valueLabel_columns);
        this.triggerList.addItemListener(this);
        this.triggerList.setInsets(new Insets(4, 4, 2, 5));
        this.add(this.triggerList);
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new BorderLayout());
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new JCAlignerLayout(4, 2, 25));
        jCContainer2.add(new JCLabel("Trigger:"));
        this.actionField = new JCEnumEditor(EventTrigger.trigger_strings, EventTrigger.trigger_values, "triggerActionEditor");
        this.actionField.getTextField().setColumns(8);
        this.actionField.getTextField().setBackground(JCPropertyPage.textBG);
        this.actionField.getList().setBackground(JCPropertyPage.textBG);
        this.actionField.addPropertyChangeListener(this);
        jCContainer2.add(this.actionField);
        jCContainer2.add(new JCLabel("    Modifier:"));
        this.modifierField = new JCEnumEditor(JCChart.eventMod_strings, JCChart.eventMod_values, "triggerTypeEditor");
        this.modifierField.getTextField().setColumns(8);
        this.modifierField.getTextField().setBackground(JCPropertyPage.textBG);
        this.modifierField.getList().setBackground(JCPropertyPage.textBG);
        this.modifierField.addPropertyChangeListener(this);
        jCContainer2.add(this.modifierField);
        jCContainer.add("Center", jCContainer2);
        JCContainer jCContainer3 = new JCContainer();
        jCContainer3.setLayout(new GridLayout(1, 4));
        jCContainer3.add(new JCLabel(""));
        this.addTriggerButton = new JCButton("Add");
        this.addTriggerButton.addActionListener(this);
        jCContainer3.add(this.addTriggerButton);
        this.removeTriggerButton = new JCButton("Remove");
        this.removeTriggerButton.addActionListener(this);
        jCContainer3.add(this.removeTriggerButton);
        jCContainer3.add(new JCLabel(""));
        jCContainer.add("South", jCContainer3);
        this.add(jCContainer);
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        JCVector jCVector = null;
        if (object instanceof JCChart) {
            this.target = (JCChart)object;
            int n = this.target.getNumTriggers();
            int n2 = 0;
            while (n2 < n) {
                EventTrigger eventTrigger;
                if (jCVector == null) {
                    jCVector = new JCVector();
                }
                if ((eventTrigger = this.target.getTrigger(n2)) != null) {
                    JCVector jCVector2 = new JCVector();
                    int n3 = eventTrigger.getAction();
                    int n4 = this.actionField.indexOf(n3);
                    if (n4 >= 0) {
                        jCVector2.addElement(this.actionField.getItem(n4));
                    } else {
                        jCVector2.addElement(new Integer(n3));
                    }
                    int n5 = eventTrigger.getModifiers();
                    n4 = this.modifierField.indexOf(n5);
                    if (n4 >= 0) {
                        jCVector2.addElement(this.modifierField.getItem(n4));
                    } else {
                        jCVector2.addElement(new Integer(n5));
                    }
                    jCVector.addElement(jCVector2);
                }
                ++n2;
            }
        }
        this.triggerList.setItems(jCVector);
        this.actionField.setValue(new Integer(-1));
        this.modifierField.setValue(new Integer(0));
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.target == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        EventTrigger eventTrigger = null;
        if (jCActionEvent.getSource() instanceof JCButton) {
            JCButton jCButton = (JCButton)jCActionEvent.getSource();
            if (jCButton == this.addTriggerButton) {
                try {
                    n2 = (Integer)this.actionField.getValue();
                    n3 = (Integer)this.modifierField.getValue();
                    if (n2 < 0 || n3 < 0) {
                        this.setObject();
                        return;
                    }
                    int n4 = this.target.getNumTriggers();
                    n = 0;
                    while (n < n4) {
                        int n5;
                        eventTrigger = this.target.getTrigger(n);
                        if (eventTrigger != null && (n5 = eventTrigger.getAction()) == n2 && n3 != eventTrigger.getModifiers()) {
                            eventTrigger.setModifiers(n3);
                            this.target.setTrigger(n, eventTrigger);
                            break;
                        }
                        ++n;
                    }
                    if (n == n4) {
                        this.target.setTrigger(n, new EventTrigger(n3, n2));
                    }
                }
                catch (Exception exception) {
                    JCCustomizerPage.showError("Bad Trigger Add: " + exception);
                }
            } else if (jCButton == this.removeTriggerButton) {
                try {
                    n2 = (Integer)this.actionField.getValue();
                    int n6 = this.target.getNumTriggers();
                    n = 0;
                    while (n < n6) {
                        int n7;
                        eventTrigger = this.target.getTrigger(n);
                        if (eventTrigger != null && (n7 = eventTrigger.getAction()) == n2) {
                            this.target.removeTrigger(n);
                            break;
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    JCCustomizerPage.showError("Trigger Remove: " + exception);
                }
            }
            this.setObject();
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCMultiColumnList && jCItemEvent.getStateChange() == 1) {
            JCMultiColumnList jCMultiColumnList = (JCMultiColumnList)jCItemEvent.getSource();
            Vector vector = (Vector)jCMultiColumnList.getSelectedItem();
            this.actionField.setValue(vector.elementAt(0));
            this.modifierField.setValue(vector.elementAt(1));
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        String string = ChartTriggerPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(ChartTriggerPage.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public static String getPageTitle() {
        return "Chart Trigger Property Page";
    }

    public static String getPageName() {
        return "ChartTriggerPage";
    }
}

