package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.Events.*;
import cern.lhcias.csgui.rtdb.*;
import cern.lhcias.csgui.Utils.*;
import java.io.*;
import java.awt.*;
import java.applet.Applet;
import java.util.*;

/*---------------------------------------------*/
public class BarGraphView extends CanvasMTagsView {
	int nb_of_ticks = 10;
	int x_origin=40, y_origin=5;       //5
	int x_border = 60, y_border = 25;   //7
	boolean gridOn = false;
	Font legendFont;
	Color backgroundColor;

    public BarGraphView() {
        super();
        TYPE = "BarGraphView";
        legendFont = new Font("Helvetica",Font.PLAIN,10);
        backgroundColor = new Color(51,51,102);
    }
	
    void TagListHasChanged() {
        repaint();
    }

	int getIndex(int x,int y) {
	    int nb = TagstoView.size();
	    if (nb < 1) return -1;
		int bar_width= (getBounds().width - x_border)/nb;
		int num = (x - x_origin)/bar_width;
		if (num >= TagstoView.size()) return -1;
		return(num);
	}

	public boolean mouseDown(Event evt,  int x, int y) {
        if (x < x_origin) {
            if (gridOn) gridOn = false;
            else gridOn = true;
            repaint();
            return false;
        }
		int clicked_tag = getIndex(x,y);
		if (clicked_tag > -1) fireTagClickedEvent((String) TagstoView.elementAt(clicked_tag));
		return false;
	}

	public void	paint(Graphics g) {
        Rectangle rec = getBounds();
		int width= rec.width - x_border, height=rec.height - y_border;
        g.setColor(backgroundColor);
        g.fillRect(x_origin,y_origin,width,height);
		g.setColor(Color.white);
		g.drawLine(x_origin,y_origin,x_origin,y_origin+height);
		g.drawLine(x_origin,y_origin+height,x_origin+width,y_origin+height);

		double d_m[] = getLimits();
		drawVerticalTicks(g,x_origin,y_origin,width, height,nb_of_ticks,d_m[0],d_m[1],3,
		                gridOn, Color.black, Color.white);

 		g.setFont(legendFont);
		FontMetrics fm = g.getFontMetrics();
		
        int nb = TagstoView.size();
		int bar_width = (width/nb) -5;
        Vector Tags = getTags();
		for (int i=0; i<nb; i++) {
		    int xpos = x_origin + 4 + i*(width/nb);
		    g.setColor(Color.black);
		    g.drawString((String) TagstoView.elementAt(i), 
		            xpos, y_origin + height + fm.getMaxAscent());
			paint_single_bar((Tag)Tags.elementAt(i), g, xpos, 
			        y_origin, bar_width, height, d_m[0], d_m[1], 
			        MyUtils.get_indexed_color(i));
		}
	}

	/*-------------------------------------------------------------------*/
	private void paint_single_bar(Tag tag, Graphics g,int x_origin, int y_origin,
		int bar_width, int bar_height, double min, double max, Color couleur) 
	{
		double b_height = (new Double(bar_height)).doubleValue();
		double height, height_to0;
		int iheight ,iheight_to0;
		g.setColor(couleur);
		
		boolean load_error = tag.getAcquisitionError();
		double double_value = tag.doubleValue();

		if (tag.isValid()) {
			height = (double_value - min) * b_height/(max-min);
			if (height > b_height) height = b_height;
			if (height < 0) height = 0;
			iheight = (new Double(height)).intValue();
			if (max*min < 0) {
				height_to0 = (double_value) * b_height/(max-min);
				iheight_to0 = (new Double(height_to0)).intValue();
				if ((iheight_to0 >= 0)) { 
				if (load_error) 
					g.drawRect(x_origin, y_origin+bar_height-iheight,
							   bar_width,iheight_to0);
				else
					g.fillRect(x_origin, y_origin+bar_height-iheight,
							   bar_width,iheight_to0);
				}
				else {
				int iheight0 = (new Double((0 - min) * b_height/(max-min))).intValue();
				if (load_error)
					g.drawRect(x_origin, y_origin +bar_height- iheight0,
							   bar_width,-iheight_to0);
				else
					g.fillRect(x_origin, y_origin +bar_height- iheight0,
							   bar_width,-iheight_to0);
				}
			}
			else {
				if (max <=0) {
					height_to0 = (double_value) * b_height/(max-min);
					iheight_to0 = (new Double(height_to0)).intValue();
					if (load_error) 
						g.drawRect(x_origin, y_origin,
								   bar_width,-iheight_to0);
					else
						g.fillRect(x_origin, y_origin,
								   bar_width,-iheight_to0);
				}
				else {
					if (load_error) 
						g.drawRect(x_origin, y_origin+bar_height-iheight,
								   bar_width,iheight);
					else
						g.fillRect(x_origin, y_origin+bar_height-iheight,
								   bar_width,iheight);
				}
			}
		}

	}
}

