package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.interfaces.*;
import cern.lhcias.csgui.Events.*;
import cern.lhcias.csgui.Utils.*;
import cern.lhcias.csgui.Services.*;
import cern.lhcias.csgui.rtdb.*;
import java.awt.*;
import java.util.Vector;

/**
*<br>
*<br>  TagsView type implemented:  PanelSTagsView
*<br>
*<br>   This class, which is a "TagsView", is a simple base class for a TagsView which display
*<br>   one tag. It is intended to be extended.
*<br>
*<br>  If the component doesn't want the tag's name to be changed, it must set
*<br>  the public boolean Changeable to false;
*<br>
*<br>  Events:
*<br>    As any TagsView, it may fires TagcCliked and Alarm events.
*<br>
*<br>  Configuration:
*<br>    The configuration is the name of the tag
*<br>
*   @see TagsView
*/
public class PanelSTagsView extends Panel implements TagsView {

public String              TYPE = "PanelSTagsView";
public boolean             Changeable = true;
public TagChangeAdapter    tadapter;
public String              TagtoView;
public TagArrays           tagArrays;
public TagClickedAdapter   tcadapter;
public OpenViewAdapter     ovadapter;
public configurationMgr    cM;
public AlarmAdapter        alarmAdapter;

//----------------------------------------------------
Vector myListeners = new Vector();

public synchronized void addTagClickedListener(TagClickedListener listener) {
     myListeners.addElement(listener);
}

public synchronized void removeTagClickedListener(TagClickedListener listener) {
     myListeners.removeElement(listener);
}

public void fireTagClickedEvent(String name) {
        TagClickedEvent tagclevt = new TagClickedEvent(this);
        tagclevt.setTagName(name);
        for (int i=0; i<myListeners.size(); i++) {
            ((TagClickedListener) myListeners.elementAt(i)).receiveTagClicked(tagclevt);
        }
}

Vector myAlarmListeners  = new Vector();

public synchronized void addAlarmListener( AlarmListener listener) {
    myAlarmListeners.addElement(listener);
}
   
public synchronized void removeAlarmListener(AlarmListener listener) {
    myAlarmListeners.removeElement(listener);
}
           
void fireAlarmEvent(String description, String aGroup, long aDate) {
    AlarmEvent alarmevt = new AlarmEvent(this, description,aGroup,aDate);
    for (int i=0; i<myAlarmListeners.size(); i++) {
        ((AlarmListener) myAlarmListeners.elementAt(i)).receiveAlarm(alarmevt);
    }
}

//---------------- TagsView implementation -----------------------------------------
public void removeOpenViewListener(OpenViewListener listener) {}
public void addOpenViewListener(OpenViewListener listener){}
public void addMouseListener(java.awt.event.MouseListener cMouse) {}
public void setProperty(String tagName, String tagProperty, String propertyValue) {}

public int getComponentNb(){
        return 0;
}

public Vector getComponentsList(){
    return(null);
}

public boolean doYouImplement(String type) {
	if (type.equalsIgnoreCase(TYPE)) return(true);
    return false;
}

public Vector getPossibleTypes() {
    Vector types = new Vector();
    types.addElement(TYPE);
    return(types);
}

public String getType(){
    return(TYPE);
}

public void removeTag(String tagName) {
    if (Changeable) {
        if (TagtoView.equals(tagName)) {
            TagtoView = null;
            TagListHasChanged();
            //---------- Subscribe to the required tag list --------------
            tadapter.subscribeTagList(this, getTagNames());
            repaint();
            }
    }
}

public void    removeTag(Vector tagNames) {
    if (Changeable) 
    for (int i=0;i<tagNames.size();i++) {
        String s = (String) tagNames.elementAt(i);
        if (s != null){
            if (s.equals(TagtoView)) {
                TagtoView = null;
                TagListHasChanged();
                tadapter.subscribeTagList(this, getTagNames());
                repaint();
                return;
            }
        }
    }
}

public void    removeTag(TagsView TVcomponent) {
    removeTag(TVcomponent.getTagNames());
}

public void addTag(String tagName) {
    if (Changeable || TagtoView==null) {
        TagtoView = tagName;
        TagListHasChanged();
        tadapter.subscribeTagList(this, getTagNames());
        repaint();
    }
}

public void    addTag(Vector tagNames) {
    if ((Changeable || TagtoView==null) && tagNames.elementAt(0) != null) {
        TagtoView = (String) tagNames.elementAt(0);
        TagListHasChanged();
        tadapter.subscribeTagList(this, getTagNames());
        repaint();
    }
}

public void    addTag(TagsView TVcomponent) {
    addTag(TVcomponent.getTagNames());
}

public void setConfig(String config) {
    if (Changeable || TagtoView==null) {
        TagtoView = config;
        TagListHasChanged();
        tadapter.subscribeTagList(this, getTagNames());
    }
}

public String toString() {
    return TagtoView;
}

public Vector getTagNames() {
    Vector Tags = new Vector();
    Tags.addElement(TagtoView);
    return Tags;
}

public Vector getLocalTagNames() {
    return(getTagNames());
}

public void instantiate(TagArrays TA, String configname, TagChangeAdapter adapter,
        TagClickedAdapter cadapter, OpenViewAdapter opadapter, 
        configurationMgr cm, AlarmAdapter aA){
    tadapter    = adapter;
    tagArrays   = TA;
    tcadapter   = cadapter;
    ovadapter   = opadapter;
    cM          = cm;
    alarmAdapter = aA;
    if (configname != null) setConfig(configname);
    init();
    //---------- Subscribe to the required tag list --------------
    tadapter.subscribeTagList(this, getTagNames());
}

public void receiveTagChange(TagChangeEvent tagevent){
    repaint();
}

// -------------------------------------------------------
    void TagListHasChanged() {}
    void init() {}
// -------------------------------------------------------
}