/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.DOMException;

abstract class NamespacedNode
extends ParentNode {
    protected String name;
    protected String namespaceURI;

    NamespacedNode() {
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPrefix() {
        return XmlNames.getPrefix(this.name);
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int index = this.name.indexOf(58);
        if (prefix == null) {
            if (index >= 0) {
                this.name = this.name.substring(index + 1);
            }
            return;
        }
        if (!XmlNames.isUnqualifiedName(prefix)) {
            throw new DomEx(5);
        }
        if (this.namespaceURI == null || "xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(this.namespaceURI)) {
            throw new DomEx(14);
        }
        if (this.getNodeType() == 2 && ("xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(this.namespaceURI) || "xmlns".equals(this.name))) {
            throw new DomEx(14);
        }
        StringBuffer tmp = new StringBuffer(prefix);
        tmp.append(':');
        if (index < 0) {
            tmp.append(this.name);
        } else {
            tmp.append(this.name.substring(index + 1));
        }
        this.name = tmp.toString();
    }

    public String getLocalName() {
        return XmlNames.getLocalPart(this.name);
    }
}

