import Sav.Z.*;
import java.io.*;
/**
 * Following example imports tabular data about users and owners,
 * then selects equal value of "User" and "Owner" class.
 * Example illustrates using of Z multitude variables
 * ("owner", "user") and diverse databases ("Owners", "Users").
 * Result will be "ann1"
 */
public class SessionMultiDBDemo {
  public static void main(String arg[]) throws IOException {
    String userData =
      "$base \"Users\";" +
      "$readTable() <" +
        "User  ; Name   ; Resource     \n" +
        "ann1  ; Ann    ; data1, data2 \n" +
        "dan   ; Daniel ; data1, data3 \n" +
      ">;"
    ;
    String ownerData =
      "$base \"Owners\";" +
      "$readTable() <" +
        "Owner  ; Name ; Resource \n" +
        "ann1   ; Ann  ; data1    \n" +
      ">;"
    ;
    Session ss = new Session();
    ss.z(userData); //creates Users database
    ss.z(ownerData); //creates Owners database
    String text =
      "= $base \"Owners\";" +
      "$owner = Owner/;" +
      "= $base \"Users\";" +
      "$user = User/$owner;"
    ;
    ss.z(text); //Forms user multitude variable
    String[] users = ss.get("user");
    System.out.println("OWNER AND USER");
    for (int i = 0; i < users.length; ++i)
      System.out.println(users[i]);
  }
}
