/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class VetoableChangeSupport
extends java.beans.VetoableChangeSupport
implements Serializable {
    protected Hashtable listenerTable;
    private Object source;
    private int vetoableChangeSupportSerializedDataVersion = 1;

    public VetoableChangeSupport(Object sourceBean) {
        super(sourceBean);
        this.source = sourceBean;
    }

    public synchronized void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.listenerTable == null) {
            this.listenerTable = new Hashtable();
        }
        Vector listenerList = this.listenerTable.containsKey(propertyName) ? (Vector)this.listenerTable.get(propertyName) : new Vector();
        listenerList.addElement(listener);
        this.listenerTable.put(propertyName, listenerList);
    }

    public synchronized void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.listenerTable == null || !this.listenerTable.containsKey(propertyName)) {
            return;
        }
        Vector listenerList = (Vector)this.listenerTable.get(propertyName);
        listenerList.removeElement(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        int i;
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        super.fireVetoableChange(propertyName, oldValue, newValue);
        Hashtable templistenerTable = null;
        VetoableChangeSupport vetoableChangeSupport = this;
        synchronized (vetoableChangeSupport) {
            if (this.listenerTable == null) return;
            if (!this.listenerTable.containsKey(propertyName)) {
                return;
            }
            templistenerTable = (Hashtable)this.listenerTable.clone();
        }
        Vector listenerList = (Vector)templistenerTable.get(propertyName);
        PropertyChangeEvent evt = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= listenerList.size()) {
                    return;
                }
                VetoableChangeListener target = (VetoableChangeListener)listenerList.elementAt(i2);
                target.vetoableChange(evt);
                ++i2;
            }
        }
        catch (PropertyVetoException veto) {
            evt = new PropertyChangeEvent(this.source, propertyName, newValue, oldValue);
            i = 0;
        }
        while (true) {
            if (i >= listenerList.size()) {
                throw veto;
            }
            try {
                VetoableChangeListener target = (VetoableChangeListener)listenerList.elementAt(i);
                target.vetoableChange(evt);
            }
            catch (PropertyVetoException propertyVetoException) {}
            ++i;
        }
    }
}

