package tester;

/**
 * @(#)Answers.java	03/19/02
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 */

/***************************************************************************/

/**
 * Answers is the object that collects the answers
 * and holds the answer key of the test.
 *
 * @version 1.2
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class Answers {

	private static String answers[] = new String[59];
	private static int counter = 0;

    /**
  	 * Collects the answers and stores them in a String array.
     */
	public void collectAnswers( String answer ) {
	answers[counter] = answer.trim();
	counter++;
	}

	/**
	 * Returns the user answer stored in the given index number.
	 * @param index the requested array index number.
     */
	public String getUserAnswer( int index ) {
		return answers[index];
	}

	/**
	 * Returns the correct answer stored in the given index number.
	 * @param index the requested array index number.
	 */
	public String getCorrectAnswer( int index ) {
		return answerKey[index];
	}

	/**
	 * Returns the answer key length.
	 */
	public int getAnswerKeyLength() {
		return answerKey.length;
	}

	private String answerKey[] = { "A",      //  1
				                   "C",      //  2
	                               "AC",     //  3
	                               "ABD",    //  4
	                               "D",      //  5
	                               "C",      //  6
	                               "D",      //  7
	                               "D",      //  8
	                               "ABC",    //  9
	                               "D",      // 10
	                               "C",      // 11
   			                       "D",      // 12
                                   "A",      // 13
                                   "ABD",    // 14
                                   "B",      // 15
                                   "B",      // 16
                                   "AD",     // 17
                                   "BD",     // 18
					               "B",      // 19
					               "BC",     // 20
							       "ACD",    // 21
							   	   "D",      // 22
								   "B",      // 23
								   "ABCD",   // 24
								   "A",      // 25
								   "B",      // 26
								   "D",      // 27
								   "B",      // 28
								   "A",      // 29
								   "C",      // 30
								   "C",      // 31
								   "D",      // 32
								   "D",      // 33
								   "BCD",    // 34
								   "C",      // 35
								   "D",      // 36
								   "A",      // 37
								   "BC",     // 38
								   "B",      // 39
								   "B",      // 40
								   "C",      // 41
								   "D",      // 42
								   "A",      // 43
								   "D",      // 44
								   "B",      // 45
								   "C",      // 46
								   "E",      // 47
								   "F",      // 48
								   "ADEF",   // 49
								   "B",      // 50
								   "B",      // 51
								   "C",      // 52
								   "C",      // 53
                                   "C",      // 54
                                   "D",      // 55
                                   "C",      // 56
                                   "B",      // 57
                                   "D",      // 58
                                   "A"   };  // 59
} //end class