package tester;

/**
 * @(#)TestLoader.java	03/19/02
 *
 *   This program is free software; you can redistribute it and" + fs + "or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */
import java.io.*;
import java.net.*;
import javax.swing.*;

/**
 * TestLoader is the object that handles the question
 * loading from the question database. It also reads and
 * returns the contents of the log file with all taken tests.
 *
 * @author Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://www30.brinkster.com/panos69/JProjects.aspx
 */
public class TestLoader {

	private BufferedReader buf1 = null, buf2 = null;
	static String files[] = new String[59];
	protected int fcounter = 0;
	protected URL INTRO = null;
    private final String fs = File.separator;
    private String dir;
    private File root,f;
    protected boolean istf = false;
    protected String tf = null;
    protected String path = null;
    protected static boolean flag = false;

    /**
     * Creates a new TestLoader object.
     */
	public TestLoader() {
		dir = System.getProperty("user.dir");
	    root = new File(dir);
	    f = new File("tester" + File.separator + "tf.ser");
		try {
            if (f.exists()) {
				path = deserialize();
			} else {
				setTestFilesHome();
			}
	        INTRO = new URL("file:///" + path + fs + "intro.html");
		} catch (MalformedURLException e){}
		for ( int i = 1;i < files.length + 1;i++) {
			files[(i-1)]= new String(i + ".html" );
	    }
    }

    /**
     * Reads the next question file.
     */
	public URL nextQuestion() {
    	URL nextQuestion = null;
		try {
			nextQuestion = new URL("file:///" + path + fs + files[fcounter]);
			fcounter++;
			if (fcounter == 59) fcounter = 0;
			return nextQuestion;
        } catch (MalformedURLException e){}
        return nextQuestion;
	}

    /**
     * Review questions
     */
	public URL review() {
    	URL nextQuestion = null;
		try {
			nextQuestion = new URL("file:///" + path + fs + files[fcounter]);
			fcounter++;
			if (fcounter == 58) {
				flag = true;
			}
			return nextQuestion;
        } catch (MalformedURLException e){}
        return nextQuestion;
	}

	/**
	 * Deserializes the path to testfiles folder.
	 */
    private String deserialize() {
    	String path = null;
        try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                path = (String) ois.readObject();
        } catch (IOException e) {
            System.out.println("\nERROR:  " + e.getMessage());
        } catch (ClassNotFoundException e) {
            System.out.println("\nERROR:  " + e.getMessage());
        }
        return path;
    }

	/**
	 * Checks on load if the path to testfiles folder is set.
	 */
    private void checkTF() {
        if (path == null) {
            String message = "Please set the path to testfiles folder";
            showMessage(message);
            setTestFilesHome();
        }
    }

	/**
	 * Sets the location of the testfiles folder
	 */
    private void setTestFilesHome() {
        String rt = root.getParent().toString();
        String s = new String();
        JFileChooser jfc_tf = new JFileChooser(dir);

        jfc_tf.isDirectorySelectionEnabled();
        jfc_tf.setFileSelectionMode(1);
        jfc_tf.setApproveButtonText("Set");
        jfc_tf.setApproveButtonToolTipText("Set path to testfiles folder");
        jfc_tf.setDialogTitle("Set path to testfiles folder");
        if (jfc_tf.showOpenDialog(null) == 0) {
            path = jfc_tf.getSelectedFile().getPath();
            try {
                if (f.exists()) f.delete();
                ObjectOutputStream sr = new ObjectOutputStream(new FileOutputStream(f));

                sr.writeObject(path);
            } catch (IOException e) {
                f.delete();
            }
            istf = true;
            showMessage("Your testfiles folder is " + path);
        } else
        if (path == null) {
            showMessage("You need to set the testfiles\n" +
                        "dir before you start the test!");
            istf = istf;
            path = path;
            return;
        }
    }

    private void showMessage(String s) {
        JOptionPane.showMessageDialog(null, s);
    }
} //end class