/*
 * Decompiled with CFR 0.152.
 */
package com.sd.test;

import com.sd.odbc.DataSource;
import com.sd.odbc.ODBC;
import com.sd.odbc.ODBCDriver;
import java.io.IOException;

public class TestOdbc {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: TestOdbc {1 | 2 | 3}");
            System.out.println("\t1 - List DataSources");
            System.out.println("\t2 - List Drivers");
            System.out.println("\t3 - Register and unregister a dbf DataSource called 'This is a test'");
            return;
        }
        if (stringArray[0].equals("1")) {
            TestOdbc.printDataSources();
        } else if (stringArray[0].equals("2")) {
            TestOdbc.printDrivers();
        } else if (stringArray[0].equals("3")) {
            TestOdbc.testRegistration();
        } else {
            System.out.println("Unrecognized option: " + stringArray[0]);
        }
    }

    public static void printDataSources() {
        DataSource[] dataSourceArray = ODBC.getDataSources();
        if (dataSourceArray == null) {
            System.out.println("getDataSources () returned null. Check your ODBC installation.");
            return;
        }
        System.out.println();
        System.out.println("Number of registered ODBC DataSource names: " + dataSourceArray.length);
        int n = 0;
        while (n < dataSourceArray.length) {
            System.out.println("\t" + dataSourceArray[n] + "; driver=" + dataSourceArray[n].getDriver());
            ++n;
        }
    }

    public static void printDrivers() {
        ODBCDriver[] oDBCDriverArray = ODBC.getDrivers();
        if (oDBCDriverArray == null) {
            System.out.println("getDrivers () returned null. Check your ODBC installation.");
            return;
        }
        int n = 0;
        while (n < oDBCDriverArray.length) {
            oDBCDriverArray[n].dump();
            ++n;
        }
    }

    public static void testRegistration() {
        String string = "Microsoft dBase Driver (*.dbf)";
        System.out.println("Registering a DSN ...");
        DataSource dataSource = ODBC.registerDataSource("This is a test", string, "DefaultDir=d:\\data;");
        if (dataSource == null) {
            System.out.println("Error registering a DSN. Check the following ODBC driver:");
            System.out.println(string);
            return;
        }
        System.out.println("DSN '" + dataSource + "' registered succesfully.");
        System.out.println("Check your ODBC DataSource Names and hit a key to unregister");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Unregistering a DSN ...");
        if (ODBC.unregisterDataSource(dataSource.getName(), dataSource.getDriver().getName())) {
            System.out.println("Unregistration successful!");
        } else {
            System.out.println("Unregistration failed!");
        }
    }
}

