package com.unipro.products.smgui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import com.unipro.smlib.*;

/**
 * @author Alexey Skorokhodov, askorokhodov@unipro.ru
 * @version 1.0
 */
public class MainFrame
    extends JFrame
    implements SmsListener, ACKListener {

    private static String TABLE_PROPERTY = "table";

    /**
     * This variable stores the number of sent/received messages.
     */
    //public static int trialCounter;

    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton clearAllButton = new JButton();
    JButton clearTablesButton = new JButton();
    JButton clearMessagesButton = new JButton();
    JButton clearACKsButton = new JButton();
    JButton checkConnectionButton = new JButton();
    JButton helpButton = new JButton();
    ImageIcon recycle;
    ImageIcon image1;
    ImageIcon checkConnectionImage;
    ImageIcon image3;
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane mainSplitPane = new JSplitPane();
    JScrollPane incomingMessagesScrollPane = new JScrollPane();
    JScrollPane acknowledgesScrollPane = new JScrollPane();
    JSplitPane messagesSplitPane = new JSplitPane();
    JLabel jLabel2 = new JLabel();
    JButton sendButton = new JButton();
    JButton clearTextButton = new JButton();
    JComboBox recipientComboBox = new JComboBox();
//    MainFrame_recipientComboBox_itemAdapter recipientComboBox = new MainFrame_recipientComboBox_itemAdapter(this);
    JPanel sendPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JScrollPane messageScrollPane = new JScrollPane();
    JTextArea messageTextArea = new JTextArea();
    JTable messagesTable = new JTable();
    JTable acknowledgesTable = new JTable();
    JLabel numberOfSymbolsLabel = new JLabel();
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JMenuItem jMenuOptionsPortSetup = new JMenuItem();
    JMenu jMenuMessage = new JMenu();
    JCheckBoxMenuItem jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem();
    JCheckBox jCheckBox1 = new JCheckBox();
    JCheckBox jCheckBox2 = new JCheckBox();
    JCheckBox jCheckBox3 = new JCheckBox();
    JCheckBox jCheckBox4 = new JCheckBox();
    JMenuItem jMenuOptionsSMSCNumber = new JMenuItem();
    JMenuItem jMenuFileClearAll = new JMenuItem();

    //Construct the frame
    public MainFrame() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);

        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
/*
    private void increaseTrialMessageCounter() {
        if (trialCounter >= SMGUIApplication.NUMBER_OF_TRIAL_ALLOWED_MESSAGES) {
            JOptionPane.showMessageDialog(this, SMGUIApplication.TRIAL_EXPIRED_MESSAGE,
                                          "Error",
                                          JOptionPane.ERROR_MESSAGE);
            throw new RuntimeException(SMGUIApplication.TRIAL_EXPIRED_MESSAGE);
        }
        trialCounter++;
    }
*/

    /**
     *    Method to process the incoming sms.
     */
    public void processMessage(InMessage mess) {
        System.out.println("New message is received from " +
                           mess.getSenderNumber() + " '" + mess.getText() +
                           "'");
        //increaseTrialMessageCounter();

        MessagesTableModel model = (MessagesTableModel) messagesTable.getModel();
        try {
            //model.addMessage(mess);
            model.insertMessage(mess, 0); //fix bug #113
            model.fireTableDataChanged();
        } catch (Exception e) {
            System.err.println("Can't add message to Table model: " + e);
        }
    }

    /**
     *    Method to process the incoming Acknowledge report.
     */
    public void processACKReport(ACKReport report) {
        System.out.println("New Ack-report is received: status=" +
                           report.getStatus());
        //increaseTrialMessageCounter();
        ACKsTableModel model = (ACKsTableModel) acknowledgesTable.getModel();
        try {
            //model.addReport(report);
            model.insertReport(report, 0); //fix bug #113
            model.fireTableDataChanged();
        } catch (Exception e) {
            System.err.println("Can't add row to Table model: " + e);
        }

    }

    //Component initialization
    private void jbInit() throws Exception {
        SMGUIApplication.smsManager.allowReception(SMGUIApplication.
                settings.isAllowedIncomingSMS());
        recycle = new ImageIcon(com.unipro.products.smgui.MainFrame.class.
                               getResource("recycle.jpg"));
        image1 = new ImageIcon(com.unipro.products.smgui.MainFrame.class.
                               getResource("remove.gif"));
        checkConnectionImage = new ImageIcon(com.unipro.products.smgui.
                                             MainFrame.class.
                                             getResource("magicwand.gif"));
        image3 = new ImageIcon(com.unipro.products.smgui.MainFrame.class.
                               getResource("help.png"));
        contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(borderLayout1);
        //this.setSize(new Dimension(494, 380));
        this.setSize(new Dimension(660, 430));
        this.setTitle("SMS Manager");
        this.addWindowListener(new MainFrame_this_windowAdapter(this));
        statusBar.setText("SMS Manager");
        jMenuFile.setText("File");
        jMenuFileExit.setText("Exit");
        jMenuFileExit.addActionListener(new
                                        MainFrame_jMenuFileExit_ActionAdapter(this));
        jMenuHelp.setText("Help");
        jMenuHelpAbout.setText("About");
        jMenuHelpAbout.addActionListener(new
                                         MainFrame_jMenuHelpAbout_ActionAdapter(this));
        clearAllButton.setIcon(image1);
        clearAllButton.setText("");
        clearAllButton.addActionListener(new MainFrame_clearAllButton_actionAdapter(this));
        clearAllButton.setToolTipText("Clear all");
        clearTablesButton.setIcon(recycle);
        clearTablesButton.setText("Clear both");
        clearTablesButton.addActionListener(new MainFrame_clearTablesButton_actionAdapter(this));
        clearTablesButton.setToolTipText("Delete all messages and acknowledgements");
        clearMessagesButton.setIcon(recycle);
        clearMessagesButton.setText("Messages");
        clearMessagesButton.addActionListener(new MainFrame_clearMessagesButton_actionAdapter(this));
        clearMessagesButton.setToolTipText("Delete all messages");
        clearACKsButton.setIcon(recycle);
        clearACKsButton.setText("ACKs");
        clearACKsButton.addActionListener(new MainFrame_clearACKsButton_actionAdapter(this));
        clearACKsButton.setToolTipText("Delete all acknowledgements");
        checkConnectionButton.setIcon(checkConnectionImage);
        checkConnectionButton.addActionListener(new
            MainFrame_checkConnectionButton_actionAdapter(this));
        checkConnectionButton.setToolTipText("Check connection");
        helpButton.setIcon(image3);
        helpButton.addActionListener(new MainFrame_helpButton_actionAdapter(this));
        helpButton.setToolTipText("Help");
//        contentPane.setMinimumSize(new Dimension(306, 200));
        contentPane.setPreferredSize(new Dimension(100, 44));

        mainSplitPane.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
//        mainSplitPane.setMinimumSize(new Dimension(306, 200));
        mainSplitPane.setPreferredSize(new Dimension(306, 200));
        mainSplitPane.setBottomComponent(null);
        mainSplitPane.setLastDividerLocation(250);
        mainSplitPane.setResizeWeight(0.0);
        mainSplitPane.setTopComponent(null);

        jMenuBar1.addMouseListener(new MainFrame_jMenuBar1_mouseAdapter(this));

//        incomingMessagesScrollPane.setMinimumSize(new Dimension(155, 50));
        incomingMessagesScrollPane.setPreferredSize(new Dimension(155, 125));

        acknowledgesScrollPane.setPreferredSize(new Dimension(155, 75));
//        acknowledgesScrollPane.setMinimumSize(new Dimension(155, 25));
        messagesSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        messagesSplitPane.setTopComponent(incomingMessagesScrollPane);

        jLabel2.setText("Message text:");
        jLabel2.setBounds(new Rectangle(8, 52, 82, 15));
        //sendButton.setBounds(new Rectangle(27, 193, 90, 25));
        //sendButton.setBounds(new Rectangle(8, 255, 90, 25));
        sendButton.setBounds(new Rectangle(8, 300, 90, 25));
        sendButton.setText("Send");
        sendButton.addActionListener(new MainFrame_sendButton_actionAdapter(this));
        clearTextButton.setBounds(new Rectangle(8, 193, 90, 25));
        clearTextButton.setText("Clear text");
        clearTextButton.addActionListener(new MainFrame_clearTextButton_actionAdapter(this));
        recipientComboBox.setModel(SMGUIApplication.recipientsModel);
        recipientComboBox.getEditor().getEditorComponent().addKeyListener(new
                                        MainFrame_recipientComboBox_keyAdapter(this));
        recipientComboBox.setBounds(new Rectangle(75, 11, 121, 21));
        recipientComboBox.setEditable(true);
//        sendPanel.setMinimumSize(new Dimension(250, 0));
        sendPanel.setBorder(BorderFactory.createEtchedBorder());
    sendPanel.setMaximumSize(new Dimension(250, 0));
        sendPanel.setPreferredSize(new Dimension(250, 0));
        sendPanel.setLayout(null);
        jLabel1.setText("Send to:");
        jLabel1.setBounds(new Rectangle(7, 14, 47, 15));

//        messageScrollPane.setMinimumSize(new Dimension(225, 25));
        messageScrollPane.setToolTipText("Enter message text here");
        messageScrollPane.setBounds(new Rectangle(6, 75, 223, 108));

        messageTextArea.setLineWrap(true);
        messageTextArea.setWrapStyleWord(true);
        messageTextArea.addCaretListener(new
                                         MainFrame_messageTextArea_caretAdapter(this));
        messageTextArea.setBorder(BorderFactory.createEtchedBorder());
        messageTextArea.setMargin(new Insets(0, 0, 0, 0));
        messagesTable.setBorder(BorderFactory.createEtchedBorder());
        messagesTable.setRequestFocusEnabled(true);
        messagesTable.setToolTipText("Incoming messages");
        messagesTable.setModel(SMGUIApplication.messagesTableModel);
        messagesTable.addMouseListener(new MainFrame_messagesTable_mouseAdapter(this));

        acknowledgesTable.addMouseListener(new
            MainFrame_acknowledgesTable_mouseAdapter(this));

        acknowledgesTable.setModel(SMGUIApplication.acksTableModel);
        acknowledgesTable.setRequestFocusEnabled(true);
        acknowledgesTable.setToolTipText("Delivery reports");
        acknowledgesTable.setBorder(BorderFactory.createEtchedBorder());
        numberOfSymbolsLabel.setText("0 symbol(s)");
        numberOfSymbolsLabel.setBounds(new Rectangle(107, 49, 112, 20));

        MouseListener popupListener = new PopupListener();
        messagesTable.addMouseListener(popupListener);
        acknowledgesTable.addMouseListener(popupListener);

        jMenuItem1.setText("Delete");
        jMenuItem1.addActionListener(new MainFrame_jMenuItem1_actionAdapter(this));

        jMenuItem2.setText("View");
        jMenuItem2.addActionListener(new MainFrame_jMenuItem2_actionAdapter(this));
        jMenuOptions.setText("Options");
        jMenuOptionsPortSetup.setText("Port setup...");
        jMenuOptionsPortSetup.addActionListener(new
            MainFrame_jMenuOptionsPortSetup_actionAdapter(this));

        jCheckBox1.setText("Ack-report");
        jCheckBox1.setBounds(new Rectangle(110, 190, 110, 20));
        jCheckBox1.addActionListener(new
            MainFrame_jCheckBox1_actionAdapter(this));
        jCheckBox1.setSelected(SMGUIApplication.settings.isRequireAcks());
        jCheckBox2.setText("Reply path");
        jCheckBox2.setBounds(new Rectangle(110, 213, 110, 20));
        jCheckBox2.addActionListener(new
            MainFrame_jCheckBox2_actionAdapter(this));
        jCheckBox2.setSelected(SMGUIApplication.settings.isReplyPath());
        jCheckBox3.setText("Flash");
        jCheckBox3.setBounds(new Rectangle(110, 236, 110, 20));
        jCheckBox3.addActionListener(new
            MainFrame_jCheckBox3_actionAdapter(this));
        jCheckBox3.setSelected(SMGUIApplication.settings.isFlash());
        jCheckBox4.setText("Reject duplicate");
        jCheckBox4.setBounds(new Rectangle(110, 259, 110, 20));
        jCheckBox4.addActionListener(new
            MainFrame_jCheckBox4_actionAdapter(this));
        jCheckBox4.setSelected(SMGUIApplication.settings.isRejectDuplicates());

        jMenuMessage.setText("Message");
        jCheckBoxMenuItem1.setText("Require Ack-report");
        jCheckBoxMenuItem1.addActionListener(new
            MainFrame_jCheckBoxMenuItem1_actionAdapter(this));
        jCheckBoxMenuItem1.setSelected(SMGUIApplication.settings.isRequireAcks());

        jCheckBoxMenuItem2.setText("Enable incoming SMS");
        jCheckBoxMenuItem2.addActionListener(new
            MainFrame_jCheckBoxMenuItem2_actionAdapter(this));
        jCheckBoxMenuItem2.setSelected(SMGUIApplication.settings.
                                       isAllowedIncomingSMS());

        jCheckBoxMenuItem3.setText("Set reply path");
        jCheckBoxMenuItem3.addActionListener(new
            MainFrame_jCheckBoxMenuItem3_actionAdapter(this));
        jCheckBoxMenuItem3.setSelected(SMGUIApplication.settings.isReplyPath());

        jCheckBoxMenuItem4.setText("Set message flash");
        jCheckBoxMenuItem4.addActionListener(new
            MainFrame_jCheckBoxMenuItem4_actionAdapter(this));
        jCheckBoxMenuItem4.setSelected(SMGUIApplication.settings.isFlash());

        jCheckBoxMenuItem5.setText("Set reject duplicate");
        jCheckBoxMenuItem5.addActionListener(new
            MainFrame_jCheckBoxMenuItem5_actionAdapter(this));
        jCheckBoxMenuItem5.setSelected(SMGUIApplication.settings.isRejectDuplicates());

        jMenuOptionsSMSCNumber.setText("SMSC number...");
        jMenuOptionsSMSCNumber.addActionListener(new
            MainFrame_jMenuOptionsSMSCNumber_actionAdapter(this));
        jMenuFileClearAll.setText("Clear all...");
        jMenuFileClearAll.addActionListener(new
            MainFrame_jMenuFileClearAll_actionAdapter(this));
        mainSplitPane.add(messagesSplitPane, JSplitPane.RIGHT);

        messagesSplitPane.add(incomingMessagesScrollPane, JSplitPane.TOP);
        incomingMessagesScrollPane.getViewport().add(messagesTable, null);
        messagesSplitPane.add(acknowledgesScrollPane, JSplitPane.BOTTOM);
        acknowledgesScrollPane.getViewport().add(acknowledgesTable, null);
        mainSplitPane.add(sendPanel, JSplitPane.LEFT);
        sendPanel.add(jLabel1, null);
        sendPanel.add(jLabel2, null);
        sendPanel.add(messageScrollPane, null);
        sendPanel.add(clearTextButton, null);
        sendPanel.add(jCheckBox1, null);
        sendPanel.add(jCheckBox2, null);
        sendPanel.add(jCheckBox3, null);
        sendPanel.add(jCheckBox4, null);
        sendPanel.add(numberOfSymbolsLabel, null);
        sendPanel.add(recipientComboBox, null);
        sendPanel.add(sendButton, null);
        messageScrollPane.getViewport().add(messageTextArea, null);

        jToolBar.add(clearAllButton);
        jToolBar.add(checkConnectionButton);
        jToolBar.add(helpButton);
        jToolBar.addSeparator(new Dimension(163,0));
        jToolBar.add(clearTablesButton);
        jToolBar.add(clearMessagesButton);
        jToolBar.add(clearACKsButton);
        contentPane.add(statusBar, BorderLayout.SOUTH);
        jMenuFile.add(jMenuFileClearAll);
        jMenuFile.add(jMenuFileExit);
        jMenuHelp.add(jMenuHelpAbout);
        jMenuBar1.add(jMenuFile);
        jMenuBar1.add(jMenuOptions);
        jMenuBar1.add(jMenuMessage);
        jMenuBar1.add(jMenuHelp);
        this.setJMenuBar(jMenuBar1);
        contentPane.add(jToolBar, BorderLayout.NORTH);
        contentPane.add(mainSplitPane, BorderLayout.CENTER);
        jPopupMenu1.add(jMenuItem1);
        jPopupMenu1.add(jMenuItem2);
        jMenuOptions.add(jMenuOptionsPortSetup);
        jMenuOptions.add(jMenuOptionsSMSCNumber);
        jMenuOptions.add(jCheckBoxMenuItem2);
        jMenuMessage.add(jCheckBoxMenuItem1);
        jMenuMessage.add(jCheckBoxMenuItem3);
        jMenuMessage.add(jCheckBoxMenuItem4);
        jMenuMessage.add(jCheckBoxMenuItem5);

        mainSplitPane.setDividerLocation(250);
        messagesSplitPane.setDividerLocation(200);
    }

    /**
     * File | Exit action performed
     */
    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        SMGUIApplication.onFinish();
        System.exit(1);
    }

    /**
     * Help | About action performed
     */
    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        showHelpAbout();
    }

    //Overridden so we can exit when window is closed
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            jMenuFileExit_actionPerformed(null);
        }
    }

    protected void showHelpAbout() {

        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation( (frmSize.width - dlgSize.width) / 2 + loc.x,
                        (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.show();
    }

    protected void showClearAllDialog() {
        String textToShow = "Are you sure you want to delete all " +
            "incoming messages, acknowledges and recipient numbers?";
        int result = JOptionPane.showConfirmDialog(this, textToShow,
            "Confirmation",
            JOptionPane.WARNING_MESSAGE);
        if (result == JOptionPane.YES_OPTION) {
            SMGUIApplication.clearAll();
        }
    }

    protected void showClearTablesDialog() {
        String textToShow = "Are you sure you want to delete all " +
            "incoming messages and acknowledgments?";
        int result = JOptionPane.showConfirmDialog(this, textToShow,
            "Confirmation",
            JOptionPane.WARNING_MESSAGE);
        if (result == JOptionPane.YES_OPTION) {
            SMGUIApplication.clearMessageTable();
            SMGUIApplication.clearACKTable();
        }
    }

    protected void showClearMessagesDialog() {
        String textToShow = "Are you sure you want to delete all " +
            "incoming messages?";
        int result = JOptionPane.showConfirmDialog(this, textToShow,
            "Confirmation",
            JOptionPane.WARNING_MESSAGE);
        if (result == JOptionPane.YES_OPTION) {
            SMGUIApplication.clearMessageTable();
        }
    }

    protected void showClearACKsDialog() {
        String textToShow = "Are you sure you want to delete all " +
            "acknowledgments?";
        int result = JOptionPane.showConfirmDialog(this, textToShow,
            "Confirmation",
            JOptionPane.WARNING_MESSAGE);
        if (result == JOptionPane.YES_OPTION) {
            SMGUIApplication.clearACKTable();
        }
    }

    private void exit() {
        SMGUIApplication.onFinish();
    }

    void messagesTable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable table = (JTable) e.getSource();
            int row = table.getSelectedRow();
            showMessage(table, row);
        }

    }

    private void showMessage(JTable table, int row) {
        DefaultTableModel defaultModel = (DefaultTableModel) table.getModel();
        if (defaultModel instanceof MessagesTableModel) {
            MessageBean message = ( (MessagesTableModel) defaultModel).
                getMessage(row);
            showIncomingMessage(message);
        }
        else if (defaultModel instanceof ACKsTableModel) {
            ACKBean message = ( (ACKsTableModel) defaultModel).getReport(row);
            showAckReport(message);
        }

    }

    private void showIncomingMessage(MessageBean message) {
        String textToShow = "From:  " + message.getMessage().getSenderNumber() +
            "\n" +
            "Time:  " + message.getMessage().getSMSCTime().getTime() + "\n" +
            "ACKs:  " + message.getMessage().isACKReportForThisMessage() + "\n" +
            "Flash:  " + message.getMessage().isFlash() + "\n" +
            "Reply path:  " + message.getMessage().getReplyPath() + "\n" +
            "Text:  " + message.getMessage().getText();

        JOptionPane.showMessageDialog(this, textToShow,
                                      "Message",
                                      JOptionPane.INFORMATION_MESSAGE);
    }

    private void showAckReport(ACKBean report) {
        String textToShow = "Time:  " +
            report.getReport().getSMSCTime().getTime() + "\n" +
            "Status:  " + report.getStatusDescription();

        JOptionPane.showMessageDialog(this, textToShow,
                                      "Acknowledge",
                                      JOptionPane.INFORMATION_MESSAGE);
    }

    void acknowledgesTable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable table = (JTable) e.getSource();
            int row = table.getSelectedRow();
            showMessage(table, row);
        }

    }

    void clearTextButton_actionPerformed(ActionEvent e) {
        clearTextMessage();
    }

    private void clearTextMessage() {
        this.messageTextArea.replaceRange("", 0, this.messageTextArea.getText().length());
    }

    void sendButton_actionPerformed(ActionEvent e) {
        sendMessage();
    }

    private void sendMessage() {
        // send the message
        //increaseTrialMessageCounter();

        String recipient = (String)this.recipientComboBox.getSelectedItem();

        String messageText = (String)this.messageTextArea.getText();

        this.setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
            OutMessage message = new OutMessage(recipient,
                                                SMGUIApplication.settings.
                                                getSmsCenterNumber(),
                                                messageText);
            message.setACKRequest(SMGUIApplication.settings.isRequireAcks());
            message.setReplyPath(SMGUIApplication.settings.isReplyPath());
            message.setFlash(SMGUIApplication.settings.isFlash());
            message.setRejectDuplicates(SMGUIApplication.settings.isRejectDuplicates());

            // save the recipient in the list
            if (recipient != null) {
                SMGUIApplication.recipientsModel.addOrUpdateRecipient(recipient);
            }
            SMGUIApplication.smsManager.sendMessage(message);
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(),
                                          "Error",
                                          JOptionPane.ERROR_MESSAGE);
        }

        this.setCursor(Cursor.getDefaultCursor());
    }

    void messageTextArea_caretUpdate(CaretEvent e) {
        updateNumberOfSymbols();
    }

    private void updateNumberOfSymbols() {
            String numberOfSymbols = this.messageTextArea.getText().length() + " symbol(s)";
            this.numberOfSymbolsLabel.setText(numberOfSymbols);
    }

    void recipientComboBox_keyPerformed(KeyEvent e) {
/*        char[] digital = {'0','1','2','3','4','5','6','7','8','9'};
        String alphabet  = new String(" qwertyuiop[]asdfghjkl;'zxcvbnm,./QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>?`-=\\~!@#$%^&*()_+|");
        char[] letters = alphabet.toCharArray();
        boolean digit = false;
        boolean letter = false;
        String recipient = ((JTextField)recipientComboBox.getEditor().getEditorComponent()).getText();
        if(recipient.length() >= 0) {
            for (int i = 0; i < digital.length; i++) {
                if (e.getKeyChar() == digital[i]) {
                    digit = true;
                    break;
                }
            }
            for (int i = 0; i < letters.length; i++) {
                if (e.getKeyChar() == letters[i]) {
                    letter = true;
                    break;
                }
            }
            if(digit) {
                if (recipient.length() > 10) {
                    ( (JTextField) recipientComboBox.getEditor().getEditorComponent()).
                        setText(recipient.substring(0, 10));
                }
                else {
                    ( (JTextField) recipientComboBox.getEditor().getEditorComponent()).
                        setText(recipient);
                }
            } else if(letter) {
                JOptionPane.showMessageDialog(this,
                    "Recipient number must be only digital value",
                                              "Error",
                                              JOptionPane.ERROR_MESSAGE);
                if (recipient.length() > 10) {
                    ( (JTextField) recipientComboBox.getEditor().getEditorComponent()).
                        setText(recipient.substring(0, 10));
                }
                else {
                    ( (JTextField) recipientComboBox.getEditor().
                     getEditorComponent()).setText(recipient.substring(0,
                        recipient.length()));
                }
            }
        }
*/    }

    void checkConnectionButton_actionPerformed(ActionEvent e) {
        checkConnection();
    }

    private void checkConnection() {
        this.setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
            SMGUIApplication.refreshSMSManager();
            JOptionPane.showMessageDialog(this, "Connection is OK",
                                          "OK",
                                          JOptionPane.INFORMATION_MESSAGE);
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(),
                                          "Error",
                                          JOptionPane.ERROR_MESSAGE);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    class PopupListener
        extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable table = (JTable) e.getSource();
                Point p = e.getPoint();
                table.setRowSelectionInterval(table.rowAtPoint(p),
                                              table.rowAtPoint(p));

                jPopupMenu1.putClientProperty(TABLE_PROPERTY, table);
                jPopupMenu1.show(e.getComponent(),
                                 e.getX(), e.getY());
            }
        }
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        JTable table = (JTable) jPopupMenu1.getClientProperty(TABLE_PROPERTY);
        int row = table.getSelectedRow();
        deleteMessage(table, row);
    }

    void deleteMessage(JTable table, int row) {
        DefaultTableModel model = (DefaultTableModel) table.getModel();
        model.removeRow(row);
        model.fireTableDataChanged();
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        JTable table = (JTable) jPopupMenu1.getClientProperty(TABLE_PROPERTY);
        int row = table.getSelectedRow();
        showMessage(table, row);
    }

    void jMenuOptionsPortSetup_actionPerformed(ActionEvent e) {
        PortSettingsDialog dlg = new PortSettingsDialog(this, "Port settings", true);
        SMGUIApplication.centerFrame(dlg);
        dlg.pack();
        dlg.show();
    }

    void jCheckBox1_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setRequireAcks(jCheckBox1.isSelected());
        jCheckBoxMenuItem1.setSelected(jCheckBox1.isSelected());
    }

    void jCheckBox2_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setReplyPath(jCheckBox2.isSelected());
        jCheckBoxMenuItem3.setSelected(jCheckBox2.isSelected());
    }

    void jCheckBox3_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setFlash(jCheckBox3.isSelected());
        jCheckBoxMenuItem4.setSelected(jCheckBox3.isSelected());
    }

    void jCheckBox4_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setRejectDuplicates(jCheckBox4.isSelected());
        jCheckBoxMenuItem5.setSelected(jCheckBox4.isSelected());
    }

    void jCheckBoxMenuItem1_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setRequireAcks(jCheckBoxMenuItem1.isSelected());
        jCheckBox1.setSelected(jCheckBoxMenuItem1.isSelected());
    }

    void jCheckBoxMenuItem2_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setAllowedIncomingSMS(jCheckBoxMenuItem2.
            isSelected());
        SMGUIApplication.smsManager.allowReception(SMGUIApplication.settings.
            isAllowedIncomingSMS());
    }

    void jCheckBoxMenuItem3_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setReplyPath(jCheckBoxMenuItem3.isSelected());
        jCheckBox2.setSelected(jCheckBoxMenuItem3.isSelected());
    }

    void jCheckBoxMenuItem4_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setFlash(jCheckBoxMenuItem4.isSelected());
        jCheckBox3.setSelected(jCheckBoxMenuItem4.isSelected());
    }

    void jCheckBoxMenuItem5_actionPerformed(ActionEvent e) {
        SMGUIApplication.settings.setRejectDuplicates(jCheckBoxMenuItem5.isSelected());
        jCheckBox4.setSelected(jCheckBoxMenuItem5.isSelected());
    }

    void jMenuOptionsSMSCNumber_actionPerformed(ActionEvent e) {
        String selectedValue = (String) JOptionPane.showInputDialog(this,
            "SMSC number", "SMSC setup",
            JOptionPane.QUESTION_MESSAGE,
            null,
            null,
            SMGUIApplication.settings.getSmsCenterNumber()
            );
        if (selectedValue != null) {
            SMGUIApplication.settings.setSmsCenterNumber(selectedValue);
        }
    }

    void helpButton_actionPerformed(ActionEvent e) {
        showHelpAbout();
    }

    void jMenuFileClearAll_actionPerformed(ActionEvent e) {
        showClearAllDialog();
    }

    void clearAllButton_actionPerformed(ActionEvent e) {
        showClearAllDialog();
    }

    void clearTablesButton_actionPerformed(ActionEvent e) {
        showClearTablesDialog();
    }

    void clearMessagesButton_actionPerformed(ActionEvent e) {
        showClearMessagesDialog();
    }

    void clearACKsButton_actionPerformed(ActionEvent e) {
        showClearACKsDialog();
    }

}

class MainFrame_jMenuFileExit_ActionAdapter
    implements ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuFileExit_actionPerformed(e);
    }
}

class MainFrame_jMenuHelpAbout_ActionAdapter
    implements ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuHelpAbout_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuHelpAbout_actionPerformed(e);
    }
}

class MainFrame_this_windowAdapter
    extends java.awt.event.WindowAdapter {
    MainFrame adaptee;

    MainFrame_this_windowAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

}

class MainFrame_jMenuBar1_mouseAdapter
    extends java.awt.event.MouseAdapter {
    MainFrame adaptee;

    MainFrame_jMenuBar1_mouseAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }
}

class MainFrame_messagesTable_mouseAdapter
    extends java.awt.event.MouseAdapter {
    MainFrame adaptee;

    MainFrame_messagesTable_mouseAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseClicked(MouseEvent e) {
        adaptee.messagesTable_mouseClicked(e);
    }
}

class MainFrame_acknowledgesTable_mouseAdapter
    extends java.awt.event.MouseAdapter {
    MainFrame adaptee;

    MainFrame_acknowledgesTable_mouseAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseClicked(MouseEvent e) {
        adaptee.acknowledgesTable_mouseClicked(e);
    }
}

class MainFrame_sendButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_sendButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.sendButton_actionPerformed(e);
    }
}

class MainFrame_clearTextButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_clearTextButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.clearTextButton_actionPerformed(e);
    }
}

class MainFrame_messageTextArea_caretAdapter
    implements javax.swing.event.CaretListener {
    MainFrame adaptee;

    MainFrame_messageTextArea_caretAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void caretUpdate(CaretEvent e) {
        adaptee.messageTextArea_caretUpdate(e);
    }
}

class MainFrame_recipientComboBox_keyAdapter
    implements KeyListener {
    MainFrame adaptee;

    MainFrame_recipientComboBox_keyAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void keyReleased(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {
        this.adaptee.recipientComboBox_keyPerformed(e);
    }
    public void keyPressed(KeyEvent e) {}
}

class MainFrame_checkConnectionButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_checkConnectionButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.checkConnectionButton_actionPerformed(e);
    }
}

class MainFrame_jMenuItem1_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuItem1_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuItem1_actionPerformed(e);
    }
}

class MainFrame_jMenuItem2_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuItem2_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuItem2_actionPerformed(e);
    }
}

class MainFrame_jMenuOptionsPortSetup_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuOptionsPortSetup_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuOptionsPortSetup_actionPerformed(e);
    }
}

class MainFrame_jCheckBox1_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;
    MainFrame_jCheckBox1_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBox1_actionPerformed(e);
    }
}

class MainFrame_jCheckBox2_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;
    MainFrame_jCheckBox2_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBox2_actionPerformed(e);
    }
}

class MainFrame_jCheckBox3_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;
    MainFrame_jCheckBox3_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBox3_actionPerformed(e);
    }
}

class MainFrame_jCheckBox4_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;
    MainFrame_jCheckBox4_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }
    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBox4_actionPerformed(e);
    }
}

class MainFrame_jCheckBoxMenuItem1_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jCheckBoxMenuItem1_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBoxMenuItem1_actionPerformed(e);
    }
}

class MainFrame_jCheckBoxMenuItem2_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jCheckBoxMenuItem2_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBoxMenuItem2_actionPerformed(e);
    }
}

class MainFrame_jCheckBoxMenuItem3_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jCheckBoxMenuItem3_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBoxMenuItem3_actionPerformed(e);
    }
}

class MainFrame_jCheckBoxMenuItem4_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jCheckBoxMenuItem4_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBoxMenuItem4_actionPerformed(e);
    }
}

class MainFrame_jCheckBoxMenuItem5_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jCheckBoxMenuItem5_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jCheckBoxMenuItem5_actionPerformed(e);
    }
}

class MainFrame_jMenuOptionsSMSCNumber_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuOptionsSMSCNumber_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuOptionsSMSCNumber_actionPerformed(e);
    }
}

class MainFrame_helpButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_helpButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.helpButton_actionPerformed(e);
    }
}

class MainFrame_jMenuFileClearAll_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_jMenuFileClearAll_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jMenuFileClearAll_actionPerformed(e);
    }
}

class MainFrame_clearAllButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_clearAllButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.clearAllButton_actionPerformed(e);
    }
}

class MainFrame_clearTablesButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_clearTablesButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.clearTablesButton_actionPerformed(e);
    }
}

class MainFrame_clearMessagesButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_clearMessagesButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.clearMessagesButton_actionPerformed(e);
    }
}

class MainFrame_clearACKsButton_actionAdapter
    implements java.awt.event.ActionListener {
    MainFrame adaptee;

    MainFrame_clearACKsButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.clearACKsButton_actionPerformed(e);
    }
}
