#!/usr/bin/perl
#########################################################################
#
# indexfile.cgi
#
# Perlscript for use with any server that has Perl installed.
#
# Check with your internet service provider if you can put
# up your own cgi scripts. You may have to change the first
# line of this page to point to where Perl is located on your server.
#
# This page will read the directory it is in and sort
# out all the *.gif and *.jpg pictures and construct the
# correct syntax for use with the Viewer applet.
# To set this file up, put it in the directory where you 
# have the pictures you want to show and then change the
# "indexfile" parameter to point to this file on the server.
#
# Example:
# <applet code="Viewer.class" width=100 height=80>
# <param name="refresh" value=10>
# <param name="indexfile" value="indexfile.cgi">
# </applet>
#
# Note that nothing will show on the page itself if you view it
# through a browser since all the picture information will be commented.
# If you want to view the picture information then view the
# source of the page.
##########################################################################

opendir( CDIR, ".");
@FILES = readdir( CDIR );
closedir( CDIR );

$path = $ENV{'PATH_INFO'};
$srvr = "http://$ENV{'SERVER_NAME'}";
$fldr = substr( $path, 0 , rindex( $path, '/' , 0 ));

print "Content-Type: text/html\n\n";

print "<HTML>\n";
print "<BODY BGCOLOR=FFFFE6>\n";
print "<!--\n\n";

foreach $file( sort( @FILES ) )
{
	$file =~ s/^\.+//g;
	$file =~ s/^,//g;

	if ( $file =~ /gif/i || $file =~ /jpg/i ) 
	{
     		print "image{\n$srvr$fldr/$file;\n;\n;\n}\n\n";
	}
}


print "-->\n";
print "</BODY>\n";
print "</HTML>\n";


