/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.Writer;
import org.webmacro.engine.AndCondition;
import org.webmacro.engine.EqualCondition;
import org.webmacro.engine.Macro;
import org.webmacro.engine.NotCondition;
import org.webmacro.engine.NotEqualCondition;
import org.webmacro.engine.OrCondition;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.TermCondition;
import org.webmacro.util.InvalidContextException;

public abstract class Condition
implements Macro {
    public static final Object parse(ParseTool parseTool) throws ParseException, IOException {
        return Condition.parseCond(parseTool);
    }

    public static Condition parseCond(ParseTool parseTool) throws ParseException, IOException {
        Condition condition;
        boolean bl = parseTool.parseChar('(');
        parseTool.parseWhitespace();
        switch (parseTool.ttype) {
            case 33: {
                condition = NotCondition.parseNot(parseTool);
                break;
            }
            case 40: {
                condition = Condition.parseCond(parseTool);
                break;
            }
            default: {
                condition = TermCondition.parseTerm(parseTool);
                break;
            }
        }
        if (condition == null) {
            throw new ParseException(parseTool, "Expected term/expression, got: " + (char)parseTool.ttype);
        }
        boolean bl2 = true;
        while (bl2) {
            Condition condition2;
            parseTool.parseWhitespace();
            switch (parseTool.ttype) {
                case 33: {
                    condition2 = NotEqualCondition.parseNotEqual(condition, parseTool);
                    break;
                }
                case 61: {
                    condition2 = EqualCondition.parseEqual(condition, parseTool);
                    break;
                }
                case 38: {
                    condition2 = AndCondition.parseAnd(condition, parseTool);
                    break;
                }
                case 124: {
                    condition2 = OrCondition.parseOr(condition, parseTool);
                    break;
                }
                default: {
                    condition2 = null;
                }
            }
            if (condition2 == null) {
                bl2 = false;
                continue;
            }
            condition = condition2;
        }
        parseTool.parseWhitespace();
        if (bl && !parseTool.parseChar(')')) {
            throw new ParseException(parseTool, "Mismatched braces around expression.");
        }
        return condition;
    }

    static final Condition parseBinOp(char[] cArray, ParseTool parseTool) throws IOException, ParseException {
        int n = 0;
        while (n < cArray.length) {
            if (!parseTool.parseChar(cArray[n])) {
                if (n == 0) {
                    return null;
                }
                throw new ParseException(parseTool, "Expected character " + cArray[n] + " after " + cArray[n - 1] + " but got " + (char)parseTool.ttype);
            }
            ++n;
        }
        parseTool.parseWhitespace();
        Condition condition = Condition.parseCond(parseTool);
        if (condition == null) {
            throw new ParseException(parseTool, "Expected term/expression after operator " + " but got: " + (char)parseTool.ttype);
        }
        return condition;
    }

    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        writer.write(this.evaluate(object).toString());
    }

    public Object evaluate(Object object) throws InvalidContextException {
        if (this.test(object)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public abstract boolean test(Object var1);
}

