/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.webmacro.engine.Template;
import org.webmacro.engine.TestObject;
import org.webmacro.util.Log;
import org.webmacro.util.java2.HashMap;

public class FileTemplate
extends Template {
    private final File myFile;

    protected Reader getReader() throws IOException {
        return new BufferedReader(new FileReader(this.myFile));
    }

    public String toString() {
        return "FileTemplate:" + this.myFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        HashMap hashMap = new HashMap();
        hashMap.put("helloworld", "Hello World");
        hashMap.put("hello", "Hello");
        hashMap.put("file", "include.txt");
        TestObject[] testObjectArray = new TestObject[]{new TestObject("apple", false), new TestObject("lemon", true), new TestObject("pear", false), new TestObject("orange", true), new TestObject("watermelon", false), new TestObject("peach", false), new TestObject("lime", true)};
        hashMap.put("fruits", testObjectArray);
        hashMap.put("flipper", new TestObject("flip", false));
        try {
            File file = new File("examples", "templateTest.wm");
            System.out.println("Creating a template from " + file);
            FileTemplate fileTemplate = new FileTemplate(file);
            System.out.println("Parsing");
            fileTemplate.parse();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            System.out.println("RESULT:");
            System.out.println();
            fileTemplate.write(outputStreamWriter, hashMap);
            ((Writer)outputStreamWriter).close();
            System.out.println("PARAMETER \"hi\" equals: " + fileTemplate.getParam("hi"));
            System.out.println("PARAMETER \"test\" equals: " + fileTemplate.getParam("test"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileTemplate(String string) {
        this.myFile = new File(string);
    }

    public FileTemplate(File file) {
        this.myFile = file;
    }
}

