/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.StringReader;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.util.Log;
import org.webmacro.util.java2.HashMap;

final class QuotedText {
    public static final String parseQuotedText(ParseTool parseTool) throws ParseException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        bl2 = parseTool.parseChar('\'');
        if (bl2) {
            bl = true;
        } else if (parseTool.parseChar('\"')) {
            bl = true;
        } else {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(96);
        boolean bl3 = false;
        while (!bl3 && parseTool.ttype != -1 && parseTool.ttype != 10) {
            switch (parseTool.ttype) {
                case 36: {
                    throw new ParseException(parseTool, "'$' are not allowed to appear " + "in current quoted String. This is exceptional behaviour " + "for quoted strings. Parse rules expect a literal string " + "in current position.");
                }
                case 39: {
                    if (bl2) {
                        bl3 = true;
                        break;
                    }
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
                case 34: {
                    if (!bl2 && bl) {
                        bl3 = true;
                        break;
                    }
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
                case -3: {
                    stringBuffer.append(parseTool.sval);
                    break;
                }
                default: {
                    stringBuffer.append((char)parseTool.ttype);
                    break;
                }
            }
            parseTool.nextToken();
        }
        if (stringBuffer.length() == 0) {
            // empty if block
        }
        if (!bl3) {
            if (parseTool.ttype == -1) {
                throw new ParseException(parseTool, "expected close quote but got EOF");
            }
            throw new ParseException(parseTool, "expected close quote but got EOL");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        try {
            HashMap hashMap = new HashMap();
            Integer n = new Integer(10);
            Integer n2 = new Integer(20);
            hashMap.put("a", n);
            hashMap.put("b", n2);
            StringReader stringReader = new StringReader("'unfinished QuotedText at end $ r'");
            ParseTool parseTool = new ParseTool("string", stringReader);
            parseTool.nextToken();
            String string = QuotedText.parseQuotedText(parseTool);
            System.out.println("expected string: /unfinished QuotedText at end $ r/");
            System.out.println("evaluated string: " + string);
            hashMap.put(string.toString(), string);
            System.out.println("");
            StringReader stringReader2 = new StringReader("\"expect no variable at all\"");
            ParseTool parseTool2 = new ParseTool("string", stringReader2);
            parseTool2.nextToken();
            String string2 = QuotedText.parseQuotedText(parseTool2);
            System.out.println("expected string: /expect no variable at all/");
            System.out.println("evaluated string: " + string2);
            System.out.println("");
            StringReader stringReader3 = new StringReader("'single \"quote no variable'");
            ParseTool parseTool3 = new ParseTool("string", stringReader3);
            parseTool3.nextToken();
            String string3 = QuotedText.parseQuotedText(parseTool3);
            System.out.println("expected string: /single \"quote no variable/");
            System.out.println("evaluated string: " + string3);
            hashMap.put(string3.toString(), string3);
            System.out.println("");
            StringReader stringReader4 = new StringReader("\"$a QuotedText at beginning\"");
            ParseTool parseTool4 = new ParseTool("string", stringReader4);
            parseTool4.nextToken();
            String string4 = QuotedText.parseQuotedText(parseTool4);
            System.out.println("expected string: /$a QuotedText at beginning/");
            System.out.println("evaluated string: " + string4);
            System.out.println("");
            StringReader stringReader5 = new StringReader("''");
            ParseTool parseTool5 = new ParseTool("string", stringReader5);
            parseTool5.nextToken();
            String string5 = QuotedText.parseQuotedText(parseTool5);
            System.out.println("expected string: //");
            System.out.println("evaluated string: " + string5);
            System.out.println("");
            return;
        }
        catch (Exception exception) {
            System.out.println("MAIN CAUGHT AN EXCEPTION");
            exception.printStackTrace();
        }
    }

    QuotedText() {
    }
}

