/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Term;
import org.webmacro.engine.Variable;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.java2.HashMap;

final class SetDirective
implements Macro {
    private final Variable myVariable;
    private final Object myValue;

    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        if (parseTool.ttype != -3 && !parseTool.sval.equals("set")) {
            return null;
        }
        parseTool.nextToken();
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "(1) expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        if (parseTool.ttype != 36) {
            throw new ParseException(parseTool, "expected $ after set key word, got: " + (char)parseTool.ttype);
        }
        Variable variable = (Variable)Variable.parse(parseTool);
        if (variable == null) {
            throw new ParseException(parseTool, "expected TT_WORD, got: " + (char)parseTool.ttype);
        }
        parseTool.parseSpaces();
        if (!parseTool.parseChar('=')) {
            throw new ParseException(parseTool, "(2) expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        parseTool.parseSpaces();
        Object object = Term.parse(parseTool);
        parseTool.parseSpaces();
        if (parseTool.parseToEOL()) {
            throw new ParseException(parseTool, "extraneous text after Term in SetDirective");
        }
        return new SetDirective(variable, object);
    }

    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        Object object2 = this.evaluate(object);
        if (object2 != null) {
            writer.write(object2.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) {
        try {
            if (this.myValue instanceof Macro) {
                this.myVariable.setValue(object, ((Macro)this.myValue).evaluate(object));
                return null;
            }
            this.myVariable.setValue(object, this.myValue);
            return null;
        }
        catch (InvalidContextException invalidContextException) {
            Engine.log.exception(invalidContextException);
            Engine.log.error("Set: Unable to set value: " + this.myVariable);
            return "<!--\n Unable to set value: " + this.myVariable + " \n-->";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        HashMap hashMap = new HashMap();
        hashMap.put("a", "paper");
        String[] stringArray2 = new String[]{"set $a = \"wood\"", "set $b = \"cake\""};
        System.out.println("- - - - - - - - - - - - - - - - -");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("TESTING: " + stringArray2[n] + " :");
            try {
                System.out.println("before set variable a: " + hashMap.get("a"));
                System.out.println("befoer set variable b: " + hashMap.get("b"));
                ParseTool parseTool = new ParseTool("string", new StringReader(stringArray2[n]));
                parseTool.nextToken();
                SetDirective setDirective = (SetDirective)SetDirective.parse(parseTool);
                if (setDirective == null) {
                    System.out.println("FAILED--null returned from parse().");
                } else {
                    Object object = setDirective.evaluate(hashMap);
                    System.out.println("after set variable a: " + hashMap.get("a"));
                    System.out.println("after set variable a: " + hashMap.get("b"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("- - - - - - - - - - - - - - - - -");
            ++n;
        }
        System.out.println();
        System.out.println("Done.");
    }

    SetDirective(Object object, Object object2) {
        this.myVariable = (Variable)object;
        this.myValue = object2;
    }
}

