
/*
 * Copyright (c) 1998, 1999 Semiotek Inc. All Rights Reserved.
 *
 * This software is the confidential intellectual property of
 * of Semiotek Inc.; it is copyrighted and licensed, not sold.
 * You may use it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation. If you 
 * do not want to use the GPL, you may still use the software after
 * purchasing a proprietary developers license from Semiotek Inc.
 *
 * This software is provided "as is", with NO WARRANTY, not even the 
 * implied warranties of fitness to purpose, or merchantability. You
 * assume all risks and liabilities associated with its use.
 *
 * See the attached License.html file for details, or contact us
 * by e-mail at info@semiotek.com to get a copy.
 */


package org.webmacro.engine;

import java.util.*;
import java.io.*;
import org.webmacro.util.*;

/**
  * This directive is used to set variables in the context data map 
  * if a variable contains a dot operator the variable will be resolved
  * accordingly. Expects the following syntax:
  * #set $abc = Term 
  */
abstract class ParamDirective implements Macro
{

   /**
     * Parse the directive. Expect format "param name = value"
     * etc.
     * @return SetDirective
     * @exception ParseException on unrecoverable parse error
     * @exception IOException on failure to read from parseTool
     */
   static public final Object parse(ParseTool in) 
      throws IOException, ParseException
   {

      String name = null;
      Hashtable paramContext = in.getParamContext();

      // look for "param" key word  
      if ((in.ttype !=  in.TT_WORD) && (!in.sval.equals("param"))) {
         if (Engine.debug) {
            Engine.log.debug("Param: " + in.sval + " unrecognized.");
         }
         return null;
      } 
     
      in.nextToken(); // advance token by one  
      if (! in.parseSpaces()) {  // expects to be at space advance till no space
         if (Engine.debug) {
	    Engine.log.debug("Param: ttype:" + (char)in.ttype);
	    Engine.log.debug("Param: sval:" + in.sval);
         }
         throw new ParseException(in,
               "(1) expected spaces after keyword, got: " + (char) in.ttype);
      }

      // allow an optional $ on the parameter name
      in.parseChar('$');

      // get parameter name
      name = in.parseString();      
      if (name == null) {
         throw new ParseException(in, 
               "Parameter name (left hand side) expected");   
      }

      in.parseSpaces();

      if (! in.parseChar('=') ) {  
         // expects to be at space adv till no space 
         throw new ParseException(in,
               "(2) expected spaces or = after keyword, got: " + (char) in.ttype);
      }

      in.parseSpaces(); 

      // parse Term
      Object value = Term.parse(in); 
      if (value == null) {
         throw new ParseException(in,
               "expected in after foreach key word, got: " + (char) in.ttype);
      }  

      // perform static evaluation of parameters
      try {
         if (value instanceof Macro) {
            value = ((Macro) value).evaluate(paramContext);
         }
      } catch (Exception e) {
         throw new ParseException(in, "Static evaluation of parameter " + name + " failed: " + e + " -- parameters must be statically resolvable based on a context containing other parameters only.");
      }

      in.parseSpaces(); 

      if (in.parseToEOL()) {
         throw new ParseException(in,
              "extraneous text after Term in Parameter Directive");  
      }

      paramContext.put(name, value);

      return (""); // replace parameter with null string
   }

}


