/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueType;

public class InterfaceCommand
extends FuncCommand {
    private static Class findInterface(String gateway) {
        String commclass = String.valueOf(String.valueOf(new StringBuffer("X10Gimli.Interface.Gateway.").append(gateway).append("Gateway")));
        try {
            Class<?> clazz = Class.forName(commclass);
            return clazz;
        }
        catch (Exception e) {
            Debug.printCallStack("Exception creating external gateway object.", e);
        }
        catch (NoClassDefFoundError e) {
            Debug.error("An error occurred loading the necessary classes for the interface.");
        }
        return null;
    }

    private static boolean existsInterface(String gateway) {
        return InterfaceCommand.findInterface(gateway) != null;
    }

    public ValueType execute(EnvironmentSmall env) {
        this.prepareParams();
        if (this.getNumParams() >= 1 && this.getNumParams() <= 3) {
            ValueType param1 = this.getParam(0);
            SystemModel m = env.getSystemModel();
            if (m != null && param1 instanceof ValueIdent) {
                Class c = InterfaceCommand.findInterface(((ValueIdent)param1).getValueString());
                if (c != null) {
                    try {
                        BasicGateway g = (BasicGateway)c.newInstance();
                        if (this.getNumParams() == 2) {
                            ValueType param2 = this.getParam(1);
                            if (param2 instanceof Value && ((Value)param2).getValueString() == "NULL") {
                                if (g.initialize(null)) {
                                    m.addConnection(g);
                                }
                            } else if (param2 instanceof Value && g.initialize((Value)param2)) {
                                m.addConnection(g);
                            } else {
                                Debug.error(303, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to initialize inferface in ").append(this.toString()).append("."))));
                            }
                        } else if (g.initialize(null)) {
                            m.addConnection(g);
                        } else {
                            Debug.error(303, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to initialize inferface in ").append(this.toString()).append(" with no parameters."))));
                        }
                        if (this.getNumParams() == 3) {
                            ValueIdent s = this.getIdentParam(2);
                            g.setName(s.getValueString());
                        }
                        ValueType valueType = null;
                        return valueType;
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Exception in interface function call.", e);
                    }
                }
                Debug.error(108, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to find interface class in ").append(this.toString()).append("."))));
            }
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting interface identifier and paramter in ").append(this.toString()).append("."))));
        return null;
    }
}

