/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public final class WhileCommand
extends Command {
    private ValueType ctCondition;
    private Command cCommand;

    public WhileCommand() {
    }

    public WhileCommand(ValueType condition, Command command) {
        this.setCondition(condition);
        this.setCommand(command);
    }

    public void setCondition(ValueType condition) {
        this.ctCondition = condition;
    }

    public void setCommand(Command command) {
        this.cCommand = command;
    }

    public ValueType getCondition() {
        return this.ctCondition;
    }

    public Command getCommand() {
        return this.cCommand;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (this.ctCondition != null && this.cCommand != null) {
            if (this.cCommand instanceof BeginCommand) {
                EnvironmentSmall newenv = env.spawnEnvironment();
                ArrayList commands = ((BeginCommand)this.cCommand).getCommands();
                if (Debug.yesLevel(4)) {
                    this.prepareOutput(env);
                    this.sBuf.append("begin");
                    Debug.log(4, this.sBuf.toString());
                }
                while (this.ctCondition.getValue(env).getBoolean()) {
                    newenv.executeCommands(commands);
                    env.setTime();
                }
                if (Debug.yesLevel(4)) {
                    this.prepareOutput(env);
                    this.sBuf.append("end");
                    Debug.log(4, this.sBuf.toString());
                }
            } else {
                while (this.ctCondition.getValue(env).getBoolean()) {
                    env.executeCommand(this.cCommand);
                    env.setTime();
                }
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("while ");
        this.sBuf.append(this.ctCondition.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("while ");
        this.sBuf.append(this.ctCondition.toX10GIMLI());
        this.sBuf.append(" do\n");
        this.sBuf.append(this.cCommand.toX10GIMLI(depth + 1));
        return this.sBuf.toString();
    }
}

