/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.GUI;

import X10Gimli.GUI.BasicGUIPanel;
import X10Gimli.Interface.Gateway.POPGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.PopPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueTime;
import X10Gimli.X10.X10Queue;
import X10Gimli.X10.X10StringToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class EmailPanel
extends BasicGUIPanel {
    String username = "adaml";
    String password = "070297";
    X10Queue listqueue = new X10Queue(5);
    X10Queue timeoutcancel = new X10Queue(5);
    EmailModel emailModel = new EmailModel(this);
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JScrollPane jScrollPaneMessage = new JScrollPane();
    JTable jTable1 = new JTable();

    public EmailPanel() {
        POPGateway pop = new POPGateway();
        this.setGateway(pop);
        pop.initialize(new ValueString("mail1.waterford.org"));
        this.getEmailHeaders();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.jTable1.setModel(this.emailModel);
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jScrollPaneMessage, "right");
        this.jSplitPane1.add((Component)this.jScrollPane2, "left");
        this.jScrollPane2.getViewport().add((Component)this.jTable1, null);
        this.jSplitPane1.setDividerLocation(100);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    EmailPanel.this.getSelectedEmail();
                }
            }
        });
    }

    private void displayMessage(String type, byte[] content) {
        this.jScrollPaneMessage.getViewport().removeAll();
        try {
            if (type.equalsIgnoreCase("text/plain")) {
                JEditorPane text = new JEditorPane(type, new String(content));
                this.jScrollPaneMessage.getViewport().add((Component)text, null);
            } else if (type.equalsIgnoreCase("text/html")) {
                JEditorPane text = new JEditorPane(type, new String(content));
                this.jScrollPaneMessage.getViewport().add((Component)text, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayEmail(Packet email) {
        if (!email.getType().equals("TIMEOUT")) {
            System.out.println(email.toString());
            String contenttype = "text/plain";
            if (email.getValue("CONTENT-TYPE") != null) {
                X10StringToken ctype = new X10StringToken(email.getValue("CONTENT-TYPE").getValueString());
                contenttype = ctype.token(1, ";");
            }
            if (contenttype.equalsIgnoreCase("multipart/mixed")) {
                this.displayEmail(this.decodeAttachment(email.getValue("MESSAGE").getValueString(), email.getValue("CONTENT-TYPE").getValueString(), 1));
            } else if (contenttype.equalsIgnoreCase("multipart/alternative")) {
                this.displayEmail(this.decodeAttachment(email.getValue("MESSAGE").getValueString(), email.getValue("CONTENT-TYPE").getValueString(), 3));
            } else if (contenttype.equalsIgnoreCase("multipart/digest")) {
                this.displayEmail(this.decodeAttachment(email.getValue("MESSAGE").getValueString(), email.getValue("CONTENT-TYPE").getValueString(), 1));
            } else if (contenttype.equalsIgnoreCase("multipart/parallel")) {
                this.displayEmail(this.decodeAttachment(email.getValue("MESSAGE").getValueString(), email.getValue("CONTENT-TYPE").getValueString(), 1));
            } else if (email.getValue("MESSAGE") != null) {
                this.displayMessage(contenttype, email.getValue("MESSAGE").getValueString().getBytes());
            } else {
                this.displayMessage("text/plain", "There is no message content.".getBytes());
            }
        }
    }

    private void getSelectedEmail() {
        int selected = this.jTable1.getSelectionModel().getMinSelectionIndex();
        if (selected != -1) {
            while (!this.listqueue.isEmpty()) {
                this.listqueue.get();
            }
            this.transmitPacket(PopPacket.PopConnectPacket(new ValueString(this.username), new ValueString(this.password)));
            PopPacket get = new PopPacket(new ValueString("GET"));
            get.setNumber(new ValueNumber((String)this.emailModel.getValueAt(selected, 0)));
            this.transmitPacket(get);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(10000L);
                        if (EmailPanel.this.timeoutcancel.isEmpty()) {
                            Packet p = new Packet();
                            p.setType("TIMEOUT");
                            EmailPanel.this.listqueue.put(p);
                        } else {
                            EmailPanel.this.timeoutcancel.get();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
            Packet email = (Packet)this.listqueue.get();
            this.transmitPacket(new PopPacket(new ValueString("DISCONNECT")));
            if (!email.getType().equals("TIMEOUT")) {
                this.timeoutcancel.put("CANCEL");
            }
            this.displayEmail(email);
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Done downloading message ").append((String)this.emailModel.getValueAt(selected, 0)).append("."))));
        }
    }

    private Packet decodeAttachment(String message, String contenttype, int number) {
        Packet decode;
        block11: {
            X10StringToken tok;
            String boundary;
            block10: {
                int boundval;
                int boundequ;
                int boundoff = contenttype.indexOf("boundary");
                if (contenttype.charAt(boundequ + 1) == '\"') {
                    boundval = contenttype.indexOf(34, ++boundequ + 2);
                } else {
                    char ch;
                    for (boundval = boundequ = contenttype.indexOf("=", boundoff); boundval < contenttype.length() && (ch = contenttype.charAt(boundval)) != ' ' && ch != '\r' && ch != '\n' && ch != '\t'; ++boundval) {
                    }
                }
                message = String.valueOf(String.valueOf(new StringBuffer(" ").append(message).append(" ")));
                boundary = "--".concat(String.valueOf(String.valueOf(contenttype.substring(boundequ + 1, boundval))));
                tok = new X10StringToken(message);
                int count = tok.countTokens(boundary);
                decode = new Packet();
                decode.setSegment("MESSAGE", new ValueString("<no message>"));
                decode.setSegment("CONTENT-TYPE", new ValueString("text/plain"));
                if (number <= 1 || number >= count) break block10;
                String attachment = tok.token(number, boundary);
                BufferedReader b = new BufferedReader(new StringReader(attachment));
                System.out.println(attachment);
                String tag = "";
                String val = "";
                try {
                    int read;
                    String input;
                    b.readLine();
                    while (!(input = b.readLine()).equals("")) {
                        if (input.length() > 0 && input.charAt(0) != ' ' && input.charAt(0) != '\t') {
                            tag = input.substring(0, input.indexOf(58));
                            val = input.substring(input.indexOf(58) + 1, input.length());
                            while (val.length() > 0 && val.charAt(0) == ' ' && input.charAt(0) != '\t') {
                                val = val.substring(1, val.length());
                            }
                            decode.setSegment(tag, new ValueString(val));
                            continue;
                        }
                        while (input.length() > 0 && input.charAt(0) == ' ') {
                            input = input.substring(1, input.length());
                        }
                        val = String.valueOf(String.valueOf(val)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(input))))));
                        decode.setSegment(tag, new ValueString(val));
                    }
                    String msg = "";
                    while ((read = b.read()) != -1) {
                        msg = String.valueOf(String.valueOf(msg)).concat(String.valueOf(String.valueOf((char)read)));
                    }
                    decode.setSegment("MESSAGE", new ValueString(msg));
                    System.out.println(decode.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break block11;
            }
            if (number != 1) break block11;
            String attachment = tok.token(number, boundary);
            decode.setSegment("MESSAGE", new ValueString(attachment));
        }
        return decode;
    }

    private void getEmailHeaders() {
        while (!this.listqueue.isEmpty()) {
            this.listqueue.get();
        }
        this.transmitPacket(PopPacket.PopConnectPacket(new ValueString(this.username), new ValueString(this.password)));
        this.transmitPacket(new PopPacket(new ValueString("LIST")));
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(10000L);
                    if (EmailPanel.this.timeoutcancel.isEmpty()) {
                        Packet p = new Packet();
                        p.setType("TIMEOUT");
                        EmailPanel.this.listqueue.put(p);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Packet list = (Packet)this.listqueue.get();
        if (!list.getType().equals("TIMEOUT")) {
            int i;
            this.timeoutcancel.put("CANCEL");
            ArrayList values = list.getValues();
            int size = values.size();
            for (i = 0; i < size; ++i) {
                PopPacket p = new PopPacket(new ValueString("HEADER"));
                p.addSegment("NUMBER", (Value)values.get(i));
                this.transmitPacket(p);
            }
            for (i = 0; i < size; ++i) {
                this.emailModel.addHeader((Packet)this.listqueue.get());
            }
        }
        this.transmitPacket(new PopPacket(new ValueString("DISCONNECT")));
        System.out.println("Done downloading headers.");
    }

    public void receivePacket(Packet p) {
        if (p.getType().equals("POP")) {
            if (p.getValue("MESSAGE0") != null) {
                this.listqueue.put(p);
            }
        } else if (p.getType().equals("EMAILHEADER")) {
            this.listqueue.put(p);
        } else if (p.getType().equals("EMAIL")) {
            this.listqueue.put(p);
        } else {
            System.out.println("An input packet has been received but is not handled by this panel.");
        }
    }

    class EmailModel
    extends AbstractTableModel {
        private ArrayList Subject = new ArrayList();
        private ArrayList From = new ArrayList();
        private ArrayList Date = new ArrayList();
        private ArrayList Time = new ArrayList();
        private ArrayList Number = new ArrayList();
        private int cNumber = 0;
        private int cSubject = 1;
        private int cFrom = 2;
        private int cDate = 3;

        EmailModel(EmailPanel this$0) {
        }

        public int getColumnCount() {
            int count = 0;
            if (this.cSubject != -1) {
                ++count;
            }
            if (this.cFrom != -1) {
                ++count;
            }
            if (this.cDate != -1) {
                ++count;
            }
            if (this.cNumber != -1) {
                ++count;
            }
            return count;
        }

        public String getColumnName(int num) {
            if (num == this.cNumber) {
                return "Number";
            }
            if (num == this.cSubject) {
                return "Subject";
            }
            if (num == this.cFrom) {
                return "From";
            }
            if (num == this.cDate) {
                return "Date";
            }
            return super.getColumnName(num);
        }

        public int getRowCount() {
            return this.Subject.size();
        }

        public Object getValueAt(int row, int col) {
            if (row >= this.getRowCount()) {
                return "";
            }
            if (col == this.cNumber) {
                return (String)this.Number.get(row);
            }
            if (col == this.cSubject) {
                return (String)this.Subject.get(row);
            }
            if (col == this.cFrom) {
                return (String)this.From.get(row);
            }
            if (col == this.cDate) {
                return (String)this.Date.get(row);
            }
            return "";
        }

        public void addNumber(String s) {
            this.Number.add(s);
        }

        public void addSubject(String s) {
            this.Subject.add(s);
        }

        public void addFrom(String s) {
            this.From.add(s);
        }

        public void addDate(String s) {
            this.Date.add(s);
        }

        public void addHeader(Packet p) {
            if (p.getType().equals("EMAILHEADER")) {
                if (p.getValue("NUMBER") != null) {
                    this.addNumber(p.getValue("NUMBER").getValueString());
                } else {
                    this.addNumber("<no number>");
                }
                if (p.getValue("SUBJECT") != null) {
                    this.addSubject(p.getValue("SUBJECT").getValueString());
                } else {
                    this.addSubject("<no subject>");
                }
                if (p.getValue("FROM") != null) {
                    this.addFrom(p.getValue("FROM").getValueString());
                } else {
                    this.addFrom("<no sender>");
                }
                if (p.getValue("DATE") != null) {
                    X10StringToken tok = new X10StringToken(p.getValue("DATE").getValueString());
                    X10StringToken time = new X10StringToken(tok.token(5, " "));
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, Integer.parseInt(tok.token(2, " ")));
                    cal.set(2, ValueMonth.monthStringToInt(tok.token(3, " ")));
                    cal.set(1, Integer.parseInt(tok.token(4, " ")));
                    cal.set(10, Integer.parseInt(time.token(1, ":")));
                    cal.set(12, Integer.parseInt(time.token(2, ":")));
                    cal.set(13, Integer.parseInt(time.token(3, ":")));
                    cal.add(10, -12);
                    this.addDate(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(new ValueDate(cal).toString()))).append(" ").append(new ValueTime(cal).toString()).append(tok.token(6, " ")))));
                } else {
                    this.addDate("<no date>");
                }
            }
        }

        public void resetColumns() {
            this.Subject = new ArrayList();
            this.From = new ArrayList();
            this.Date = new ArrayList();
            this.Time = new ArrayList();
        }
    }
}

