/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;

public class LocalDebugGateway
extends InputOutputGateway
implements OutputListener {
    public LocalDebugGateway() {
        this.sSource = "LOCALDEBUG";
        Debug.addOutputListener(this);
    }

    public boolean initialize(Value param) {
        Debug.error(100, "\"Cannot initialize debug gateway in X10GIMLI code.\"");
        return false;
    }

    protected void sendPacket(Packet packet) {
        if (packet.getType().equals("X10GIMLI")) {
            if (packet.getValue("COMMAND").getValueString().equals("LOG_ON")) {
                Debug.onYesLevel(packet.getValue("LOG").getNumber());
            } else if (packet.getValue("COMMAND").getValueString().equals("LOG_OFF")) {
                Debug.offYesLevel(packet.getValue("LOG").getNumber());
            } else if (packet.getValue("COMMAND").getValueString().equals("LOG_TOGGLE")) {
                Debug.toggleYesLevel(packet.getValue("LOG").getNumber());
            }
        }
    }

    public void transmitPacket(Packet pack) {
        this.sendPacket(pack);
    }

    public void transmitDebug(Packet pack) {
        super.transmitPacket(pack);
        this.inputReceived(pack);
    }
}

