/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface;

import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.Interface.InputListener;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.Packet;
import X10Gimli.X10.X10Queue;
import java.util.Vector;

public abstract class InputOutputGateway
extends BasicGateway {
    private Vector inputListeners = new Vector();
    private X10Queue iQueue = new X10Queue(10);
    private X10Queue oQueue = new X10Queue(10);
    private Vector outputListeners = new Vector();

    public synchronized void addInputListener(InputListener l) {
        if (!this.inputListeners.contains(l)) {
            this.inputListeners.addElement(l);
        }
    }

    public synchronized void removeInputListener(InputListener l) {
        if (this.inputListeners != null) {
            this.inputListeners.removeElement(l);
        }
    }

    public synchronized void addOutputListener(OutputListener l) {
        if (!this.outputListeners.contains(l)) {
            this.outputListeners.addElement(l);
        }
    }

    public synchronized void removeOutputListener(OutputListener l) {
        if (this.outputListeners != null) {
            this.outputListeners.removeElement(l);
        }
    }

    protected void inputReceived(Packet p) {
        this.iQueue.put(p);
    }

    private void firePacket(Packet packet) {
        if (this.isDestination(packet)) {
            Vector v = null;
            InputOutputGateway inputOutputGateway = this;
            synchronized (inputOutputGateway) {
                if (this.inputListeners != null) {
                    v = (Vector)this.inputListeners.clone();
                }
            }
            if (v != null) {
                int cnt = v.size();
                for (int i = 0; i < cnt; ++i) {
                    InputListener client = (InputListener)v.elementAt(i);
                    client.receivePacket(packet);
                }
            }
        }
    }

    private void fireOutPacket(Packet packet) {
        if (packet.getSource().length() == 0) {
            packet.setSource(this.sSource);
        }
        this.sendPacket(packet);
        Vector v = null;
        InputOutputGateway inputOutputGateway = this;
        synchronized (inputOutputGateway) {
            if (this.outputListeners != null) {
                v = (Vector)this.outputListeners.clone();
            }
        }
        if (v != null) {
            int cnt = v.size();
            for (int i = 0; i < cnt; ++i) {
                OutputListener client = (OutputListener)v.elementAt(i);
                client.transmitPacket(packet);
            }
        }
    }

    protected abstract void sendPacket(Packet var1);

    public void transmitPacket(Packet evt) {
        if (evt.toString().equals("")) {
            new Exception().printStackTrace();
        }
        this.oQueue.put(evt);
    }

    protected void startQueueThread() {
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(InputOutputGateway.this.getName()).append(" input queue handler thread started.\""))));
                while (InputOutputGateway.this.iQueue == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Interrupted sleep in input queue handler thread.", e);
                    }
                }
                while (true) {
                    Packet p = (Packet)InputOutputGateway.this.iQueue.get();
                    InputOutputGateway.this.firePacket(p);
                }
            }
        });
        t1.start();
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(InputOutputGateway.this.getName()).append(" output queue handler thread started.\""))));
                while (InputOutputGateway.this.oQueue == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Interrupted sleep in output queue handler thread.", e);
                    }
                }
                while (true) {
                    Packet p = (Packet)InputOutputGateway.this.oQueue.get();
                    InputOutputGateway.this.fireOutPacket(p);
                }
            }
        });
        t2.start();
    }
}

