/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public final class ValueDay
extends Value {
    private int iDay;

    public ValueDay() {
    }

    public ValueDay(String string) {
        this.setValueString(string.toUpperCase());
        this.setDay(this.getValueString());
    }

    public ValueDay(int day) {
        this.setDay(day);
    }

    public void setDay(int day) {
        this.iDay = ((day - 1) % 7 + 7) % 7 + 1;
        this.makeString();
    }

    public void setDay(String day) {
        this.iDay = ValueDay.dayStringToInt(day);
        this.makeString();
    }

    public int getDay() {
        return this.iDay;
    }

    public int getNumber() {
        return this.iDay;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueDay || cmp instanceof ValueNumber) {
            if (op == "+") {
                return new ValueDay(this.getDay() + this.getNumber());
            }
            if (op == "-") {
                return new ValueDay(this.getDay() - this.getNumber());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for DAY type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueDay || cmp instanceof ValueNumber || cmp instanceof ValueDate) {
            if (this.getNumber() > cmp.getNumber()) {
                return 1;
            }
            if (this.getNumber() < cmp.getNumber()) {
                return -1;
            }
            if (this.getNumber() == cmp.getNumber()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to DAY type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public Calendar resetTime(EnvironmentSmall env) {
        Calendar temp = Calendar.getInstance();
        temp.add(5, 1);
        return temp;
    }

    public String toString() {
        switch (this.iDay) {
            case 1: {
                return "SUNDAY";
            }
            case 2: {
                return "MONDAY";
            }
            case 3: {
                return "TUESDAY";
            }
            case 4: {
                return "WEDNESDAY";
            }
            case 5: {
                return "THURSDAY";
            }
            case 6: {
                return "FRIDAY";
            }
            case 7: {
                return "SATURDAY";
            }
        }
        return "";
    }

    public static int dayStringToInt(String day) {
        if (day.equalsIgnoreCase("SUN")) {
            return 1;
        }
        if (day.equalsIgnoreCase("SUNDAY")) {
            return 1;
        }
        if (day.equalsIgnoreCase("MON")) {
            return 2;
        }
        if (day.equalsIgnoreCase("MONDAY")) {
            return 2;
        }
        if (day.equalsIgnoreCase("TUE")) {
            return 3;
        }
        if (day.equalsIgnoreCase("TUESDAY")) {
            return 3;
        }
        if (day.equalsIgnoreCase("WED")) {
            return 4;
        }
        if (day.equalsIgnoreCase("WEDNESDAY")) {
            return 4;
        }
        if (day.equalsIgnoreCase("THU")) {
            return 5;
        }
        if (day.equalsIgnoreCase("THURSDAY")) {
            return 5;
        }
        if (day.equalsIgnoreCase("FRI")) {
            return 6;
        }
        if (day.equalsIgnoreCase("FRIDAY")) {
            return 6;
        }
        if (day.equalsIgnoreCase("SAT")) {
            return 7;
        }
        if (day.equalsIgnoreCase("SATURDAY")) {
            return 7;
        }
        return 0;
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

