/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import X10Gimli.Value.ValueX10;

public class ValueIdent
extends Value {
    public ValueIdent() {
    }

    public ValueIdent(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            if (string.charAt(0) == '\'') {
                this.setValueString(string.substring(1, string.length() - 1).toUpperCase());
            } else {
                this.setValueString(string.toUpperCase());
            }
        } else {
            this.setValueString("");
        }
        this.makeString();
    }

    public String getIdent() {
        return this.getValueString();
    }

    public static Class findPreDefined(String predefined) {
        predefined = predefined.toLowerCase();
        String valclass = String.valueOf(String.valueOf(new StringBuffer("X10Gimli.Value.PreDefined.Value").append(predefined.substring(0, 1).toUpperCase()).append(predefined.substring(1, predefined.length()))));
        try {
            Class<?> clazz = Class.forName(valclass);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            Debug.printCallStack("Exception creaing external identifier object.", e);
        }
        catch (NoClassDefFoundError e) {
            Debug.error("An error occurred loading the necessary classes for the predefined identifier.");
        }
        return null;
    }

    public static boolean existsPreDefined(String predefined) {
        return ValueIdent.findPreDefined(predefined) != null;
    }

    public static ValueIdent getPreDefined(String predefined) {
        Class c = ValueIdent.findPreDefined(predefined);
        if (c != null) {
            try {
                ValueIdent val = (ValueIdent)c.newInstance();
                val.setValueString(predefined);
                val.makeString();
                ValueIdent valueIdent = val;
                return valueIdent;
            }
            catch (Exception e) {
                Debug.printCallStack("Exception while creating identifier object.", e);
            }
        }
        return new ValueIdent(predefined);
    }

    public Value getValue(EnvironmentSmall env) {
        if (env != null) {
            SystemModel m = env.getSystemModel();
            Definition def = env.findDefinition(this.getValueString());
            if (def == null) {
                Value val;
                if (m != null && (val = m.getTaggedValue(this.getValueString())) != null) {
                    return val;
                }
                return this;
            }
            if (def.getValue() != null) {
                return def.getValue().getValue(env);
            }
        }
        return this;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if ((cmp instanceof ValueIdent || cmp instanceof ValueNumber || cmp instanceof ValueX10 || cmp instanceof ValueDay || cmp instanceof ValueMonth || cmp instanceof ValueCommand) && op == "+") {
            return new ValueIdent(String.valueOf(String.valueOf(this.toString())).concat(String.valueOf(String.valueOf(cmp.toString())))).getValue(env);
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for IDENT type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueIdent) {
            if (this.getValueString().compareTo(cmp.getValueString()) > 0) {
                return 1;
            }
            if (this.getValueString().compareTo(cmp.getValueString()) < 0) {
                return -1;
            }
            if (this.getValueString().compareTo(cmp.getValueString()) == 0) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to IDENT type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public String toString() {
        return this.getValueString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

