/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;

public final class ValueX10
extends Value {
    private char cHouseCode;
    private int iDeviceCode;

    public ValueX10() {
        this.cHouseCode = (char)65;
        this.iDeviceCode = 0;
    }

    public ValueX10(String string) {
        this.setValueString(string.toUpperCase());
        this.setX10(this.getValueString());
    }

    public ValueX10(char housecode, int devicecode) {
        this.setHouseCode(housecode);
        this.setDeviceCode(devicecode);
    }

    public void setHouseCode(char housecode) {
        this.cHouseCode = housecode;
        this.makeString();
    }

    public void setDeviceCode(int devicecode) {
        this.iDeviceCode = devicecode;
        this.makeString();
    }

    public void setX10(String x10) {
        this.cHouseCode = x10.charAt(0);
        if (x10.length() > 1) {
            this.iDeviceCode = Integer.parseInt(x10.substring(1, x10.length()));
        }
        this.makeString();
    }

    public char getHouseCode() {
        return this.cHouseCode;
    }

    public int getDeviceCode() {
        return this.iDeviceCode;
    }

    public int getNumber() {
        return this.iDeviceCode;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueX10 || cmp instanceof ValueNumber) {
            if (op == "+") {
                return new ValueX10(this.getHouseCode(), this.getDeviceCode() + cmp.getNumber());
            }
            if (op == "-") {
                return new ValueX10(this.getHouseCode(), this.getDeviceCode() - cmp.getNumber());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for X10 type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueX10) {
            if (this.getHouseCode() == cmp.getHouseCode() && this.getDeviceCode() > cmp.getDeviceCode()) {
                return 1;
            }
            if (this.getHouseCode() == cmp.getHouseCode() && this.getDeviceCode() < cmp.getDeviceCode()) {
                return -1;
            }
            if (this.getHouseCode() == cmp.getHouseCode() && this.getDeviceCode() == cmp.getDeviceCode()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to X10 type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public String toString() {
        this.sbuf.setLength(0);
        if (this.iDeviceCode != 0) {
            this.sbuf.append(this.cHouseCode);
            this.sbuf.append(this.iDeviceCode);
        } else {
            this.sbuf.append(this.cHouseCode);
        }
        return this.sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

