/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.X10;

public class X10Data {
    public static final byte X10_FUNCTION_ALL_UNITS_OFF = 0;
    public static final byte X10_FUNCTION_ALL_LIGHTS_ON = 1;
    public static final byte X10_FUNCTION_ON = 2;
    public static final byte X10_FUNCTION_OFF = 3;
    public static final byte X10_FUNCTION_DIM = 4;
    public static final byte X10_FUNCTION_BRIGHT = 5;
    public static final byte X10_FUNCTION_ALL_LIGHTS_OFF = 6;
    public static final byte X10_FUNCTION_EXTENDED_CODE = 7;
    public static final byte X10_FUNCTION_HAIL_REQUEST = 8;
    public static final byte X10_FUNCTION_HAIL_ACKNOWLEDGE = 9;
    public static final byte X10_FUNCTION_PRESET_DIM_1 = 10;
    public static final byte X10_FUNCTION_PRESET_DIM_2 = 11;
    public static final byte X10_FUNCTION_EXTENDED_DATA_TRANSFER = 12;
    public static final byte X10_FUNCTION_STATUS_ON = 13;
    public static final byte X10_FUNCTION_STATUS_OFF = 14;
    public static final byte X10_FUNCTION_STATUS_REQUEST = 15;
    private static final byte[] codeToValue;
    private static final int[] valueToDeviceCode;
    private static final char[] valueToHouseCode;

    public static byte houseCodeToByte(char houseCode) throws IllegalArgumentException {
        if (houseCode >= 'a' && houseCode <= 'z') {
            houseCode = (char)(houseCode - 97 + 65);
        }
        switch (houseCode) {
            case 'A': {
                return codeToValue[1];
            }
            case 'B': {
                return codeToValue[2];
            }
            case 'C': {
                return codeToValue[3];
            }
            case 'D': {
                return codeToValue[4];
            }
            case 'E': {
                return codeToValue[5];
            }
            case 'F': {
                return codeToValue[6];
            }
            case 'G': {
                return codeToValue[7];
            }
            case 'H': {
                return codeToValue[8];
            }
            case 'I': {
                return codeToValue[9];
            }
            case 'J': {
                return codeToValue[10];
            }
            case 'K': {
                return codeToValue[11];
            }
            case 'L': {
                return codeToValue[12];
            }
            case 'M': {
                return codeToValue[13];
            }
            case 'N': {
                return codeToValue[14];
            }
            case 'O': {
                return codeToValue[15];
            }
            case 'P': {
                return codeToValue[16];
            }
        }
        throw new IllegalArgumentException("Invalid house code: ".concat(String.valueOf(String.valueOf(houseCode))));
    }

    public static String functionCodeToString(int func) {
        switch (func) {
            case 0: {
                return new String("ALLUNITSOFF");
            }
            case 1: {
                return new String("ALLLIGHTSON");
            }
            case 2: {
                return new String("ON");
            }
            case 3: {
                return new String("OFF");
            }
            case 4: {
                return new String("DIM");
            }
            case 5: {
                return new String("BRIGHT");
            }
            case 6: {
                return new String("ALLLIGHTSOFF");
            }
            case 7: {
                return new String("EXTENDEDCODE");
            }
            case 8: {
                return new String("HAILREQUEST");
            }
            case 9: {
                return new String("HAILACKNOWLEDGE");
            }
            case 10: {
                return new String("PRESETDIM1");
            }
            case 11: {
                return new String("PRESETDIM2");
            }
            case 12: {
                return new String("EXTENDEDDATATRANSFER");
            }
            case 13: {
                return new String("STATUSON");
            }
            case 14: {
                return new String("STATUSOFF");
            }
            case 15: {
                return new String("STATUSREQUEST");
            }
        }
        return null;
    }

    public static int stringToFunctionCode(String func) {
        if (func.equalsIgnoreCase("ALLUNITSOFF")) {
            return 0;
        }
        if (func.equalsIgnoreCase("ALLLIGHTSON")) {
            return 1;
        }
        if (func.equalsIgnoreCase("ON")) {
            return 2;
        }
        if (func.equalsIgnoreCase("OFF")) {
            return 3;
        }
        if (func.equalsIgnoreCase("DIM")) {
            return 4;
        }
        if (func.equalsIgnoreCase("BRIGHT")) {
            return 5;
        }
        if (func.equalsIgnoreCase("ALLLIGHTSOFF")) {
            return 6;
        }
        if (func.equalsIgnoreCase("EXTENDEDCODE")) {
            return 7;
        }
        if (func.equalsIgnoreCase("HAILREQUEST")) {
            return 8;
        }
        if (func.equalsIgnoreCase("HAILACKNOWLEDGE")) {
            return 9;
        }
        if (func.equalsIgnoreCase("PRESETDIM1")) {
            return 10;
        }
        if (func.equalsIgnoreCase("PRESETDIM2")) {
            return 11;
        }
        if (func.equalsIgnoreCase("EXTENDEDDATATRANSFER")) {
            return 12;
        }
        if (func.equalsIgnoreCase("STATUSON")) {
            return 13;
        }
        if (func.equalsIgnoreCase("STATUSOFF")) {
            return 14;
        }
        if (func.equalsIgnoreCase("STATUSREQUEST")) {
            return 15;
        }
        return 0;
    }

    public static char byteToHouseCode(byte code) {
        return valueToHouseCode[code];
    }

    public static byte deviceCodeToByte(int deviceCode) {
        if (deviceCode < 16 && deviceCode >= 0) {
            return codeToValue[deviceCode];
        }
        return 0;
    }

    public static int byteToDeviceCode(byte code) {
        return valueToDeviceCode[code];
    }

    public static int normalizeMonth(int month) {
        if (month > 11) {
            return 11;
        }
        if (month < 0) {
            return 0;
        }
        return month;
    }

    public static int normalizeDay(int month, int day) {
        if (day < 1) {
            return 1;
        }
        if ((month = X10Data.normalizeMonth(month)) == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11) {
            if (day > 31) {
                return 31;
            }
            return day;
        }
        if (month == 3 || month == 5 || month == 8 || month == 10) {
            if (day > 30) {
                return 30;
            }
            return day;
        }
        if (day > 29) {
            return 29;
        }
        return day;
    }

    public static int dayOfYear(int month, int day) {
        int[] daysInMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int dayOfYear = 0;
        month = X10Data.normalizeMonth(month);
        day = X10Data.normalizeDay(month, day);
        for (int i = 0; i < month; ++i) {
            dayOfYear += daysInMonth[i];
        }
        return dayOfYear += day - 1;
    }

    static {
        X10_FUNCTION_ALL_UNITS_OFF = 0;
        X10_FUNCTION_ALL_LIGHTS_ON = 1;
        X10_FUNCTION_ON = (byte)2;
        X10_FUNCTION_OFF = (byte)3;
        X10_FUNCTION_DIM = (byte)4;
        X10_FUNCTION_BRIGHT = (byte)5;
        X10_FUNCTION_ALL_LIGHTS_OFF = (byte)6;
        X10_FUNCTION_EXTENDED_CODE = (byte)7;
        X10_FUNCTION_HAIL_REQUEST = (byte)8;
        X10_FUNCTION_HAIL_ACKNOWLEDGE = (byte)9;
        X10_FUNCTION_PRESET_DIM_1 = (byte)10;
        X10_FUNCTION_PRESET_DIM_2 = (byte)11;
        X10_FUNCTION_EXTENDED_DATA_TRANSFER = (byte)12;
        X10_FUNCTION_STATUS_ON = (byte)13;
        X10_FUNCTION_STATUS_OFF = (byte)14;
        X10_FUNCTION_STATUS_REQUEST = (byte)15;
        codeToValue = new byte[]{-1, 6, 14, 2, 10, 1, 9, 5, 13, 7, 15, 3, 11, 0, 8, 4, 12};
        valueToDeviceCode = new int[]{13, 5, 3, 11, 15, 7, 1, 9, 14, 6, 4, 12, 16, 8, 2, 10};
        valueToHouseCode = new char[]{'M', 'E', 'C', 'K', 'O', 'G', 'A', 'I', 'N', 'F', 'D', 'L', 'P', 'H', 'B', 'J'};
    }
}

