/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.X10;

import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.X10addressPacket;
import X10Gimli.System.Packet.X10functionPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueX10;
import java.util.Vector;

public class X10Tracker {
    private int[] iCommands = new int[256];
    private char cLastHouseCode = '\u0000';
    private Packet adjustedPacket;
    private boolean bLastCommand = false;

    public Packet inputPacket(Packet input) {
        if ((input = input.getPacketType()) instanceof X10addressPacket || input instanceof X10functionPacket) {
            char housecode = input.getValue("X10").getHouseCode();
            if (input instanceof X10addressPacket) {
                X10addressPacket ap = (X10addressPacket)input;
                if (housecode != this.cLastHouseCode) {
                    this.bLastCommand = false;
                    this.adjustedPacket = new Packet();
                    this.adjustedPacket.setType("X10");
                    this.adjustedPacket.addSegment("ADDRESS", ap.getX10());
                } else if (this.bLastCommand) {
                    this.bLastCommand = false;
                    this.adjustedPacket = new Packet();
                    this.adjustedPacket.setType("X10");
                    this.adjustedPacket.addSegment("ADDRESS", ap.getX10());
                } else {
                    boolean bReplaced = false;
                    for (int i = 0; i < this.adjustedPacket.getValues().size(); ++i) {
                        if (!(this.adjustedPacket.getValue(i) instanceof ValueX10)) continue;
                        if (!ap.getX10().applyCondition("==", this.adjustedPacket.getValue(i), null).getBoolean()) break;
                        bReplaced = true;
                        break;
                    }
                    if (!bReplaced) {
                        this.adjustedPacket.addSegment("ADDRESS", ap.getX10());
                    }
                }
            }
            if (input instanceof X10functionPacket) {
                X10functionPacket fp = (X10functionPacket)input;
                if (housecode != this.cLastHouseCode) {
                    this.adjustedPacket = new Packet();
                    this.adjustedPacket.setType("X10");
                    this.adjustedPacket.addSegment("ADDRESS", fp.getX10());
                    this.adjustedPacket.addSegment("COMMAND", fp.getCommand());
                    if (fp.getDims() != null) {
                        this.adjustedPacket.addSegment("DIMS", fp.getDims());
                    }
                } else if (this.bLastCommand) {
                    ValueCommand c = (ValueCommand)this.adjustedPacket.getValue("COMMAND");
                    c.setCommand(fp.getCommand().getCommand());
                    ValueNumber b = (ValueNumber)this.adjustedPacket.getValue("DIMS");
                    if (fp.getDims() != null) {
                        if (b != null) {
                            b.setNumber(fp.getDims().getNumber());
                        } else {
                            this.adjustedPacket.addSegment("DIMS", fp.getDims());
                        }
                    }
                } else {
                    this.adjustedPacket.addSegment("COMMAND", fp.getCommand());
                }
                this.bLastCommand = true;
            }
            this.cLastHouseCode = housecode;
        }
        if (this.adjustedPacket != null) {
            this.adjustedPacket.packData();
        }
        return this.adjustedPacket;
    }

    public Vector getAddressValues() {
        return null;
    }

    public Value getAddressValue() {
        return this.adjustedPacket.getValue("ADDRESS");
    }

    public Value getFunctionValue() {
        return this.adjustedPacket.getValue("COMMAND");
    }

    public Value getFunctionExtra() {
        Value v = this.adjustedPacket.getValue("DIMS");
        return v != null ? v : ValueNothing.value;
    }
}

