/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.util.StringTokenizer;
import java.util.Vector;
import tools.BaseApplet;
import tools.BaseThread;
import tools.Globals;
import tools.PngImageProducer;
import tools.Problem;
import tools.TestMonitor;
import tools.TraceMonitor;
import tools.TypeConverter;

public final class ProblemsList
extends BaseApplet {
    public static int curProblem = -1;
    public static int selProblem = -1;
    static int topLine;
    static Vector[] texts;
    Scrollbar scroll;
    Image offscreenImage;
    Graphics ig;
    Font f;
    FontMetrics fm;
    int w;
    int h;
    int th;
    int sh;
    int pageSize;
    int wSpace;
    int wNumber;
    int wCompl;
    int wText;
    int wTime;
    int wStatus;
    Color foreColor;
    Color backColor;
    Color lineColor;
    Color curForeColor;
    Color curBackColor;
    static Image statusVirgin;
    static Image statusVisited;
    static Image statusRegistered;
    static Image statusRight;
    static Image statusWrong;

    public static void reset() {
        curProblem = -1;
        selProblem = -1;
        topLine = 0;
        texts = null;
    }

    public void init() {
        int n;
        super.init();
        this.foreColor = TypeConverter.parseColor(this.getParameter("foreColor"), Color.black);
        this.backColor = TypeConverter.parseColor(this.getParameter("backColor"), Color.lightGray);
        this.lineColor = TypeConverter.parseColor(this.getParameter("lineColor"), Color.black);
        this.curForeColor = TypeConverter.parseColor(this.getParameter("curForeColor"), Color.black);
        this.curBackColor = TypeConverter.parseColor(this.getParameter("curBackColor"), new Color(208, 208, 208));
        String string = this.getParameter("fontName");
        if (string == null) {
            string = "TimesRoman";
        }
        if ((n = TypeConverter.toInteger(this.getParameter("fontSize"))) == 0) {
            n = 12;
        }
        boolean bl = this.getParameter("fontBold") != null;
        boolean bl2 = this.getParameter("fontItalic") != null;
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        this.setLayout(new BorderLayout());
        this.scroll = new Scrollbar();
        this.scroll.setValues(0, 0, 0, 0);
        this.add("East", this.scroll);
        this.layout();
        this.w = this.size().width - this.scroll.size().width;
        this.h = this.size().height;
        this.offscreenImage = this.createImage(this.w, this.h);
        this.ig = this.offscreenImage.getGraphics();
        this.f = new Font(string, n2, n);
        this.ig.setFont(this.f);
        this.fm = this.ig.getFontMetrics();
        this.th = this.fm.getHeight() * 2 / 3 + 2;
        this.sh = this.th / 2;
        this.pageSize = this.h / (this.th + this.sh);
        this.wSpace = this.fm.stringWidth(" ");
        this.wNumber = this.fm.stringWidth(" 999");
        this.wCompl = this.fm.stringWidth(" 9 ");
        this.wTime = this.fm.stringWidth(" 99:99:99 ");
        this.wStatus = this.th + this.sh;
        int n3 = this.wNumber + this.wCompl + this.wTime + this.wStatus + 2 * this.wSpace;
        this.wText = this.w - n3;
        if (this.wText < 0) {
            this.wText = 0;
        }
        if (statusVirgin == null) {
            try {
                statusVirgin = this.createImage(new PngImageProducer(this._makeURL("/decor/test/statusVirgin.png")));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (statusVisited == null) {
            try {
                statusVisited = this.createImage(new PngImageProducer(this._makeURL("/decor/test/statusVisited.png")));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (statusRegistered == null) {
            try {
                statusRegistered = this.createImage(new PngImageProducer(this._makeURL("/decor/test/statusRegistered.png")));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (statusRight == null) {
            try {
                statusRight = this.createImage(new PngImageProducer(this._makeURL("/decor/test/statusRight.png")));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        if (statusWrong == null) {
            try {
                statusWrong = this.createImage(new PngImageProducer(this._makeURL("/decor/test/statusWrong.png")));
                return;
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
        }
    }

    public void start() {
        curProblem = -1;
        if (texts != null) {
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < texts.length) {
                if (texts[n2] != null) {
                    n += texts[n2].size();
                } else {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.setScroll(n);
                return;
            }
        }
        this.thread = new BaseThread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    public void run() {
        boolean bl;
        Thread thread = Thread.currentThread();
        Problem[] problemArray = TestMonitor.problems;
        if (problemArray == null || problemArray.length == 0) {
            return;
        }
        if (texts == null) {
            texts = new Vector[problemArray.length];
        }
        int n = -1;
        do {
            bl = true;
            int n2 = 0;
            int n3 = 0;
            while (n3 < problemArray.length) {
                if (problemArray[n3] != null) {
                    if (texts[n3] != null) {
                        n2 += texts[n3].size();
                    } else {
                        String string = problemArray[n3].getText();
                        if (string == null) {
                            bl = false;
                            ++n2;
                        } else {
                            ProblemsList.texts[n3] = this.format(string);
                            n2 += texts[n3].size();
                            this.repaint();
                        }
                    }
                }
                ++n3;
            }
            if (n2 != n) {
                n = n2;
                this.setScroll(n2);
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        } while (!bl && thread == this.thread);
    }

    void setScroll(int n) {
        this.scroll.setValues(topLine, 1, 0, n - this.pageSize + 1);
        this.scroll.setPageIncrement(this.pageSize);
    }

    Vector format(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.trim().length() == 0) {
            vector.addElement("?");
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer(256);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = stringBuffer.length();
            if (n > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            String string3 = new String(stringBuffer);
            if (this.fm.stringWidth(string3) <= this.wText - 8 * this.wSpace) continue;
            if (n > 0) {
                vector.addElement(string3.substring(0, n));
                stringBuffer = new StringBuffer(256);
                stringBuffer.append(string2);
                continue;
            }
            vector.addElement(string3);
            stringBuffer = new StringBuffer(256);
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(new String(stringBuffer));
        }
        return vector;
    }

    int lineToProblem(int n) {
        if (texts == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < texts.length) {
            if (n < (n3 += texts[n2] == null ? 1 : texts[n2].size())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        this.ig.setColor(this.backColor);
        this.ig.fillRect(0, 0, this.w, this.h);
        Problem[] problemArray = TestMonitor.problems;
        if (problemArray == null) {
            return;
        }
        if (texts == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < texts.length) {
            int n6 = n = texts[n4] == null ? 1 : texts[n4].size();
            if (topLine < (n5 += n)) {
                n2 = n4;
                n3 = topLine - n5 + n;
                break;
            }
            ++n4;
        }
        n = this.th + this.sh;
        int n7 = 0;
        int n8 = n - this.sh / 2;
        int n9 = n2;
        while (n9 < problemArray.length) {
            if (problemArray[n9] != null) {
                int n10 = texts[n9] == null ? 1 : texts[n9].size() - n3;
                int n11 = n10 * n;
                if (n9 == curProblem) {
                    this.ig.setColor(this.curBackColor);
                    this.ig.fillRect(1, n7 + 1, this.w - 2, n11 - 1);
                }
                Color color = this.foreColor;
                if (n9 == curProblem) {
                    color = this.curForeColor;
                }
                int n12 = 0;
                String string = " " + (n9 + 1);
                int n13 = this.fm.stringWidth(string);
                this.ig.setColor(color);
                this.ig.drawString(string, n12 + this.wNumber - n13, n8);
                this.ig.setColor(this.lineColor);
                this.ig.drawLine(n12 += this.wNumber + 1, n7, n12, n7 + n11);
                string = String.valueOf(problemArray[n9].compl);
                n13 = this.fm.stringWidth(string);
                this.ig.setColor(color);
                this.ig.drawString(string, n12 + this.wCompl - n13, n8);
                this.ig.setColor(this.lineColor);
                this.ig.drawLine(n12 += this.wCompl + 1, n7, n12, n7 + n11);
                Image image = null;
                switch (TestMonitor.problemsStatus[n9]) {
                    case 0: {
                        image = statusVirgin;
                        break;
                    }
                    case 1: {
                        image = statusVisited;
                        break;
                    }
                    case 2: {
                        image = TestMonitor.mode == 1 ? statusRegistered : statusRight;
                        break;
                    }
                    case 3: {
                        Image image2 = image = TestMonitor.mode == 1 ? statusRegistered : statusWrong;
                    }
                }
                if (image != null) {
                    this.ig.drawImage(image, n12 + 1 + (this.wStatus - image.getWidth(this)) / 2, n7 + 1 + (n - image.getHeight(this)) / 2, this);
                }
                this.ig.setColor(this.lineColor);
                this.ig.drawLine(n12 += this.wStatus + 1, n7, n12, n7 + n11);
                if (this.wText > 0) {
                    this.ig.setColor(color);
                    if (texts[n9] != null) {
                        int n14 = n3;
                        int n15 = n8;
                        while (n14 < texts[n9].size()) {
                            String string2 = (String)texts[n9].elementAt(n14);
                            this.ig.drawString(" " + string2, n12, n15);
                            ++n14;
                            n15 += n;
                        }
                    } else {
                        this.ig.drawString(" . . .", n12, n8);
                    }
                }
                n3 = 0;
                this.ig.setColor(this.lineColor);
                this.ig.drawLine(n12 += this.wText + 1, n7, n12, n7 + n11);
                this.ig.setColor(color);
                string = TestMonitor.problems == null ? "" : TestMonitor.t2s(TestMonitor.problemsTime[n9], 0);
                n13 = this.fm.stringWidth(string);
                this.ig.drawString(string, n12 + (this.wTime - n13) / 2, n8);
                n12 += this.wTime + 1;
                this.ig.setColor(this.lineColor);
                this.ig.drawLine(0, n7 + n11, this.w, n7 + n11);
                n8 += n11;
                if ((n7 += n11) > this.h - 1) break;
            }
            ++n9;
        }
        this.ig.setColor(this.lineColor);
        this.ig.drawRect(0, 0, this.w - 1, this.h - 1);
        graphics.drawImage(this.offscreenImage, 0, 0, null);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (n >= this.w) {
            return true;
        }
        int n3 = topLine + n2 / (this.th + this.sh);
        curProblem = this.lineToProblem(n3);
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (n >= this.w) {
            return true;
        }
        int n3 = topLine + n2 / (this.th + this.sh);
        selProblem = this.lineToProblem(n3);
        if (selProblem != -1 && TestMonitor.problems != null && TestMonitor.problems[selProblem] != null) {
            Globals.cloneId = selProblem + 1;
            TraceMonitor.eventGo(TestMonitor.problems[selProblem].getPath());
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        curProblem = -1;
        this.repaint();
        return true;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                topLine = this.scroll.getValue();
                curProblem = -1;
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

