C++
C**********    P I X E L    **********
C
      SUBROUTINE PIXEL(IX, IY, ICOLOR, READ, WRITE)
      USE MSFLIB
C
C  Read and/or write pixel of color ICOLOR at position (IX, IY) on Windows95
C    screen.  If writing and the input value of ICOLOR is the negative of 
C    the highest color number in the palette, then colors 0 and |ICOLOR| will
C    be exchanged and all other colors will be rotated by half the width of 
C    the palette; repeating the operation will restore the original color.
C
C  P.A.Seeger, May 27, 1994
C    01 Jun 1994: change from write-only to read/write/rotate options; add
C                  READ, and WRITE to calling sequence [PAS]
C    18 Apr 1996: convert to Windows95, Microsoft PowerStation Fortran [PAS]
C
C  Variables in calling sequence:
C    IX, IY = screen position in pixels, measured from upper-left corner (input)
C    ICOLOR = color number, in range 0-15 or 0-255 (input/output)
C    READ = flag that previous color value is to be returned in ICOLOR (input)
C    WRITE = flag that new color is to be written to display memory (input)
      IMPLICIT NONE
      INTEGER  IX,IY,ICOLOR
      LOGICAL  READ,WRITE
C
C  No externals
C--
C  Local variables:
C    ICNEW,ICOLD = local values of ICOLOR
C    ICWHITE = if ICOLOR<0, the highest color number in the palette (white)
C    IC2 = dummy variable to receive result of "SET..." functions
C    IX2,IY2 = local (I*2) copies of IX,IY
C    ROTATE = flag that new color is to be rotation of old color
      INTEGER*2 ICNEW,ICOLD,ICWHITE,IX2,IY2,IC2
      LOGICAL   ROTATE
C
      IX2 = IX
      IY2 = IY
      ROTATE = WRITE .AND. ICOLOR.LT.0
      IF (READ .OR. ROTATE) ICOLD = GETPIXEL(IX2, IY2)
C
      IF (ROTATE) THEN
C        New color will be computed from old
         ICWHITE = IABS(ICOLOR)
         IF (ICOLD .EQ. 0) THEN
            ICNEW = ICWHITE
         ELSE IF (ICOLD .EQ. ICWHITE) THEN
            ICNEW = 0
         ELSE
            ICNEW = MOD(ICOLD+ICWHITE/2-1, ICWHITE-1) + 1
         END IF
      ELSE
         ICNEW = ICOLOR
      END IF
C
      IF (WRITE) THEN
         IC2 = SETCOLOR(ICNEW)
         IC2 = SETPIXEL(IX2, IY2)
      END IF
C
C     Modify ICOLOR only if specifically requested
      IF (READ) ICOLOR = ICOLD
      RETURN
      END 
