     TITLE   SUBROUTINE MANDELAZ(REAL, IMAG, NMAX, N, ESCAPE, AZIMUTH, OUTFLAG)
;
;P. A. Seeger, Los Alamos National Laboratory, March 28, 1989
;    (derived from MANDEL, March 28, 1988)
;    14 Nov 1991: keep x2 and y2 in stack (20% faster)
;    18 Dec 1991: also return azimuth of escaping trajectory 
;    13 May 1992: fix error in ESCAPE for N > 32767
;    19 Apr 1996: inserted into template produced by MS PowerStation Fortran 4.0
;    30 Apr 1996: added OUTFLAG to calling sequence to save unnecessary calculation
;
;Iterate  z <== z*z + c, starting from z = 0 + 0*i, where c = REAL + IMAG*i,
;   for a maximum of NMAX tries, quitting whenever abs(z*z) > 1000000.  Return 
;   the number of iterations as N, N-log2[ln(|z|)] as ESCAPE, and the angle
;   of the last computed point as AZIMUTH.
;
;         REAL    = Re(c), REAL*8, input
;         IMAG    = Im(c), REAL*8, input
;         NMAX    = maximum number of iterations, INTEGER*2, input
;         N       = number of iterations done, INTEGER*2, output
;         ESCAPE  = "Escape Time" = -log2[(ln|z|)/2**N], REAL*4, output
;         AZIMUTH = arctan(Im(z)/Re(z)), REAL*4, output
;
;   Iteration:
;             Z := z*z + c
;     X = Re(Z) := Re(z)*Re(z) - Im(z)*Im(z) + Re(c) = x*x - y*y + a
;     Y = Im(Z) := 2*Re(z)*Im(z) + Im(c)             = 2*x*y + b
;
.386P
.model FLAT
EXTRN     __FFljj:NEAR
_DATA SEGMENT
_MandelAz DB 'MandelAz.asm', 00H
_DATA  ENDS
PUBLIC    _MANDELAZ@28
EXTRN     __fltused:NEAR
_CONST SEGMENT
HUGE      DD      1000000.0          ;value to compare with abs(z*z)
ZERO      DD      0.0
_CONST ENDS
;
_TEXT SEGMENT
_REAL$ = 8
_IMAG$ = 12
_NMAX$ = 16
_N$ = 20
_ESCAPE$ = 24
_AZIMUTH$ = 28
_OUTFLAG$ = 32
_MANDELAZ@28 PROC NEAR
;
          mov     ecx, DWORD PTR _REAL$[esp-4] ;address of REAL       
          sub     esp, 4
          push    ebx
          fld     QWORD PTR [ecx]    ;place a=Re(c) in processor stack
          push    esi
          mov     esi, DWORD PTR _IMAG$[esp+8] ;address of IMAG
          push    edi
          push    ebp
          fld     QWORD PTR [esi]    ;place b=Im(c) in processor stack
;
          FLD     ST(1)              ;initial Re(z) = x := Re(c) = a
          FLD     ST(1)              ;initial Im(z) = y := Im(c) = b
          mov     eax,               DWORD PTR _OUTFLAG$[esp+16] ;address of OUTFLAG   
          FLD     ST(1)              ;x
          FMUL    ST(0),ST(0)        ;x2 := x*x
          mov     ebx, DWORD PTR [eax]  ;OUTFLAG to register ebx
          mov     ebp, DWORD PTR _NMAX$[esp+16]  ;address of NMAX
          FLD     ST(1)              ;y
          FMUL    ST(0),ST(0)        ;y2 := y*y, stack is y2  x2  y  x  b  a
;
          mov     ECX, DWORD PTR [ebp]  ;NMAX to loop count register
          XOR     EDX,EDX            ;set iteration count to zero
          mov     ebp, DWORD PTR _N$[esp+16] ;address of N
AGAIN:    INC     DX                 ;iteration counter
                                     ;Stack:  y2     x2    y     x    b    a  -  -
          FSUBP   ST(1),ST(0)        ;      x2-y2    y     x     b    a    -  -  -
          FADD    ST(0),ST(4)        ;        X      y     x     b    a    -  -  -
;
          FXCH    ST(2)              ;        x      y     X     b    a    -  -  -
          FMULP   ST(1),ST(0)        ;       x*y     X     b     a    -    -  -  -
          FADD    ST(0),ST(0)        ;      2*x*y    X     b     a    -    -  -  -
          FADD    ST(0),ST(2)        ;        Y      X     b     a    -    -  -  -
;
          FLD     ST(1)              ;        X      Y     X     b    a    -  -  -
          FMUL    ST(0),ST(0)        ;        X2     Y     X     b    a    -  -  -
          FLD     ST(1)              ;        Y      X2    Y     X    b    a  -  -
          FMUL    ST(0),ST(0)        ;        Y2     X2    Y     X    b    a  -  -
;
          FLD     ST(1)              ;        X2     Y2    X2    Y    X    b  a  -
          FADD    ST(0),ST(1)        ;      |Z*Z|    Y2    X2    Y    X    b  a  -
          fcomp   DWORD PTR HUGE     ;        Y2     X2    Y     X    b    a  -  -
;                                      Stack is now same as start of loop
          fnstsw  ax
          test    ah, 65             ; 00000041H
          je      SHORT DIVERGED     ;abs(z*z) > 1000000.0 
          LOOPW   AGAIN              ;  no -- try again (if not NMAX tries yet)
          mov     DWORD PTR [ebp], edx  ;return N := NMAX to calling program
          CMP     ebx,0              ;look at OUTFLAG
          JL      DONE               ;not storing either ESCAPE or AZIMUTH
          JZ      ESC0
AZ0:      FLDZ                       ;AZIMUTH := 0
          JMP     SHORT STOR_AZ
ESC0:     FLD1
          FIADD   DWORD PTR [ebp]    ;ESCAPE := NMAX + 1
          JMP     SHORT STOR_ESC
;       
DIVERGED: mov     DWORD PTR [ebp], edx  ;return N to calling program
          CMP     ebx,0              ;look at OUTFLAG
          JL      DONE               ;not storing either ESCAPE or AZIMUTH
          JZ      ESCAPE
AZMUTH:   FXCH    ST(2)              ;        Y      X2     Y2    X   b   a   -   -
          FLD     ST(3)              ;        X      Y      X2    Y2  X   b   a   -
          FPATAN                     ;    atan(Y/X)  X2     Y2    X   b   a   -   -
          fcom    DWORD PTR ZERO
          fnstsw  ax
          test    ah, 1
          je      STOR_AZ
          FLDPI                      ;       pi  atan(Y/X)  X2   Y2   X   b   a   -  
          FADD    ST(0),ST(0)        ;      2pi  atan(Y/X)  X2   Y2   X   b   a   -  
          FADD                       ;   AZIMUTH  on top of stack  
STOR_AZ:  mov     ecx, DWORD PTR _AZIMUTH$[esp+16]  ;address of AZIMUTH
          fstp    DWORD PTR [ecx]    ;return AZIMUTH to calling program
          JMP     SHORT DONE
;
ESCAPE:   FADDP   ST(1),ST(0)        ;      |Z*Z|     Y     X     b    a   -  -  -
          FLD1                       ;        1     |Z*Z|   Y     X    b   a  -  -
          FLDLN2                     ;      ln(2)     1   |Z*Z|   Y    X   b  a  -
          FLD1                       ;        1     ln(2)   1   |Z*Z|  Y   X  b  a
          FXCH    ST(3)              ;      |Z*Z|   ln(2)   1     1    Y   X  b  a
          FYL2X                      ;     2*ln|Z|    1     1     Y    X   b  a  -
                    ;ln(2)*log2(z**2) = ln(z**2) = 2*ln|z|
          FYL2X                      ;  log2(2*ln|Z|)  1    Y     X    b   a  -  -
          FSUBP   ST(1),ST           ;  -log2(ln|Z|)   Y    X     b    a   -  -  -
                    ;1.0-log2(2*ln|z|) = -log2(ln|z|)
          FIADD   DWORD PTR [ebp]    ;      ESCAPE  on top of stack
                    ;N-log2(ln|z|) = -log2[(ln|z|)/2**N]
STOR_ESC: mov     ecx, DWORD PTR _ESCAPE$[esp+16]  ;address of ESCAPE
          fstp    DWORD PTR [ecx]    ;return ESCAPE to calling program
;
DONE:     pop     ebp
          pop     edi
          pop     esi
          pop     ebx
          finit
          add     esp, 4
          ret     28
_MANDELAZ@28 ENDP
_TEXT     ENDS
END
