/*
 * Decompiled with CFR 0.152.
 */
package tools;

import tools.Globals;
import tools.Problem;
import tools.ProblemsList;
import tools.Tree;

public final class TestMonitor {
    public static final int INACTIVE = 0;
    public static final int TESTING = 1;
    public static final int VIEWING = 2;
    public static int mode;
    public static String name;
    static long timeLimit;
    public static String subtreePath;
    public static String topicPath;
    public static String exitPath;
    public static Problem[] problems;
    static int problemInd;
    static long totalTime;
    static long startTime;
    static long[] problemsTime;
    public static final int SHOW_TIME_SEC = 0;
    public static final int SHOW_TIME_MIN = 1;
    public static final int SHOW_TIME_NOT = 2;
    public static final int SHOW_TIME_CNT = 3;
    static int totalTimeMode;
    static int problemTimeMode;
    public static final int VIRGIN = 0;
    public static final int VISITED = 1;
    public static final int RIGHT = 2;
    public static final int WRONG = 3;
    public static int[] problemsStatus;

    public static void _Init(String string, String string2, String string3) {
        subtreePath = string;
        topicPath = string2;
        exitPath = string3;
        Tree.subtree = null;
        Tree.current = null;
        Tree.root.reset_();
        timeLimit = 0L;
    }

    public static boolean isReady() {
        if (!Tree.isReady()) {
            return false;
        }
        if (Tree.subtree != null) {
            return true;
        }
        Tree.subtree = Tree.find(subtreePath);
        Tree.current = Tree.find(topicPath);
        if (Tree.current == null) {
            Tree.current = Tree.subtree;
        }
        int[] nArray = Tree.current == null ? TestMonitor.emptyArray() : Tree.current.countProblems();
        int n = 10;
        int n2 = 0;
        while (n2 < 4) {
            if (nArray[n2] >= 1) {
                int n3 = Math.min(nArray[n2], n);
                Tree.current.setOrder(n2, n3);
                if ((n -= n3) <= 0) break;
            }
            ++n2;
        }
        return true;
    }

    public static int[] howManyProblemsInSelectedTopicTotal() {
        if (Tree.current == null) {
            return TestMonitor.emptyArray();
        }
        return Tree.current.countProblems();
    }

    public static int[] howManyProblemsInSelectedTopicAvailable() {
        if (Tree.current == null) {
            return TestMonitor.emptyArray();
        }
        return Tree.current.countProblemsAvailable();
    }

    public static int[] howManyProblemsHaveOrderedTotal() {
        if (Tree.subtree == null) {
            return TestMonitor.emptyArray();
        }
        return Tree.subtree.countProblemsOrdered();
    }

    public static int[] howManyProblemsHaveOrderedInSubtopicsOfSelectedTopic() {
        if (Tree.current == null) {
            return TestMonitor.emptyArray();
        }
        return Tree.current.countProblemsOrderedInChildren();
    }

    public static int[] getOrderForSelectedTopic() {
        if (Tree.current == null) {
            return TestMonitor.emptyArray();
        }
        return Tree.current.getOrder();
    }

    public static void setOrderForSelectedTopic(int n, int n2) {
        if (Tree.current == null) {
            return;
        }
        Tree.current.setOrder(n, n2);
    }

    static int[] emptyArray() {
        int[] nArray = new int[4];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    public static void _Start() {
        mode = 1;
        problemInd = -1;
        totalTime = 0L;
        ProblemsList.curProblem = -1;
        ProblemsList.selProblem = -1;
        ProblemsList.topLine = 0;
        ProblemsList.texts = null;
        Globals.clear();
        problems = null;
        problemsTime = null;
        problemsStatus = null;
        if (Tree.subtree == null) {
            return;
        }
        problems = Tree.subtree.generateTest();
        if (problems == null) {
            return;
        }
        int n = problems.length;
        problemsTime = new long[n];
        problemsStatus = new int[n];
        int n2 = 0;
        while (n2 < n) {
            TestMonitor.problemsTime[n2] = 0L;
            TestMonitor.problemsStatus[n2] = 0;
            ++n2;
        }
    }

    public static void _Stop() {
        mode = 2;
    }

    public static void _Exit() {
        mode = 0;
        Globals.clear();
    }

    public static void problemLoaded() {
        if (problems == null) {
            return;
        }
        problemInd = ProblemsList.selProblem;
        if (problemInd == -1) {
            return;
        }
        Problem problem = problems[problemInd];
        if (problem == null) {
            return;
        }
        if (mode == 1 && problemsStatus[problemInd] == 0) {
            TestMonitor.problemsStatus[TestMonitor.problemInd] = 1;
        }
        startTime = System.currentTimeMillis();
    }

    public static void registerAnswer(boolean bl) {
        if (problems == null || problemInd == -1) {
            return;
        }
        TestMonitor.problemsStatus[TestMonitor.problemInd] = bl ? 2 : 3;
    }

    public static void timeStamp() {
        if (problems == null || problemInd == -1) {
            return;
        }
        if (mode == 1) {
            long l = System.currentTimeMillis();
            long l2 = l - startTime;
            startTime = l;
            totalTime += l2;
            int n = problemInd;
            problemsTime[n] = problemsTime[n] + l2;
        }
    }

    public static void totalTimeMode() {
        ++totalTimeMode;
        totalTimeMode %= 3;
    }

    public static void problemTimeMode() {
        ++problemTimeMode;
        problemTimeMode %= 3;
    }

    public static String getTimeLimit() {
        return TestMonitor.t2s(timeLimit, 1);
    }

    public static void setTimeLimit(String string) {
        timeLimit = TestMonitor.s2t(string);
    }

    public static String getTotalTime() {
        return TestMonitor.t2s(totalTime, totalTimeMode);
    }

    public static String getProblemTime() {
        if (problems == null || problemInd == -1) {
            return "";
        }
        return TestMonitor.t2s(problemsTime[problemInd], problemTimeMode);
    }

    public static String getProblemTime(int n, int n2) {
        if (problems == null) {
            return "";
        }
        return TestMonitor.t2s(problemsTime[n], n2);
    }

    public static boolean isTimeLimitExhausted() {
        if (timeLimit == 0L) {
            return false;
        }
        return totalTime > timeLimit;
    }

    static String t2s(long l, int n) {
        if (n == 2) {
            return "";
        }
        long l2 = (l /= 1000L) / 3600L;
        long l3 = (l %= 3600L) / 60L;
        long l4 = l % 60L;
        return l2 + ":" + (l3 < 10L ? "0" + l3 : String.valueOf(l3)) + (n == 1 ? "" : ":" + (l4 < 10L ? "0" + l4 : String.valueOf(l4)));
    }

    static long s2t(String string) {
        try {
            int n;
            int n2 = string.indexOf(":");
            int n3 = n = n2 == -1 ? -1 : string.indexOf(":", n2 + 1);
            if (n2 == -1 && n == -1) {
                return Integer.valueOf(string).intValue();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n == -1) {
                n4 = Integer.valueOf(string.substring(0, n2));
                n5 = Integer.valueOf(string.substring(n2 + 1));
            } else {
                n4 = Integer.valueOf(string.substring(0, n2));
                n5 = Integer.valueOf(string.substring(n2 + 1, n));
                n6 = Integer.valueOf(string.substring(n + 1));
            }
            return (long)(n4 * 3600 + n5 * 60 + n6) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    static {
        name = "";
        subtreePath = null;
        topicPath = null;
        exitPath = null;
        problems = null;
        problemInd = -1;
    }
}

