/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import tools.BaseApplet;
import tools.TraceMonitor;
import tools.TypeConverter;
import tools.Var;
import tools.VarMonitor;

public class Control
extends BaseApplet
implements Var {
    Component component;
    int w;
    int h;
    Image offscreenImage;
    Graphics offscreenImageGraphics;
    boolean disabled;
    boolean hidden;
    Color foreColor;
    Color backColor;
    String fontName = "";
    int fontSize;
    boolean fontBold;
    boolean fontItalic;
    String radio;
    String status;
    boolean entered;

    public String getName() {
        return this.getParameter("name");
    }

    public String getRadioGroup() {
        return this.radio;
    }

    public String getRadioField() {
        return null;
    }

    public void init() {
        super.init();
        try {
            this.w = Integer.valueOf(this.getParameter("width"));
            this.h = Integer.valueOf(this.getParameter("height"));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void resize(int n, int n2) {
        super.resize(this.w, this.h);
    }

    void doInit() {
        super.doInit();
        this.initComponent();
        if (this.component == null) {
            this.offscreenImage = this.createImage(this.w, this.h);
            this.offscreenImageGraphics = this.offscreenImage.getGraphics();
            this.repaint();
        }
    }

    void doDestroy() {
        super.doDestroy();
        Component component = this.component;
        if (component != null) {
            this.remove(component);
        }
        if (this.offscreenImageGraphics != null) {
            this.offscreenImageGraphics.dispose();
            this.offscreenImageGraphics = null;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    void doRegister(boolean bl) {
        VarMonitor.register(this._getDocPath(), this, this, bl);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Object object = this.initMutex;
        synchronized (object) {
            if (this.offscreenImage != null) {
                this.doUpdate(this.offscreenImageGraphics);
                graphics.drawImage(this.offscreenImage, 0, 0, null);
            }
            return;
        }
    }

    void doUpdate(Graphics graphics) {
    }

    Component createComponent() {
        return null;
    }

    void initComponent() {
        Component component = this.createComponent();
        this.getProps(component);
        this.setProps(component);
        this.addComponent(component);
    }

    void addComponent(Component component) {
        if (component == null) {
            this.repaint();
        } else {
            this.setLayout(new BorderLayout(0, 0));
            this.add("Center", component);
            this.layout();
        }
        this.component = component;
    }

    void recreateComponent() {
        Component component = this.component;
        if (component != null) {
            this.remove(component);
        }
        component = this.createComponent();
        this.setProps(component);
        this.addComponent(component);
    }

    void getProps(Component component) {
        this.disabled = this.getParameter("disabled") != null;
        this.hidden = this.getParameter("hidden") != null;
        this.foreColor = TypeConverter.parseColor(this.getParameter("foreColor"), this.getForeground());
        this.backColor = TypeConverter.parseColor(this.getParameter("backColor"), this.getBackground());
        this.fontName = this.getParameter("fontName");
        if (this.fontName == null) {
            this.fontName = "Courier";
        }
        this.fontSize = TypeConverter.toInteger(this.getParameter("fontSize"));
        if (this.fontSize == 0) {
            this.fontSize = 12;
        }
        this.fontBold = this.getParameter("fontBold") != null;
        this.fontItalic = this.getParameter("fontItalic") != null;
        this.radio = this.getParameter("radio");
        this.status = this.getParameter("status");
    }

    void setProps(Component component) {
        if (component == null) {
            return;
        }
        component.setFont(this.createFont());
        component.setForeground(this.foreColor);
        component.setBackground(this.backColor);
        component.enable(!this.disabled);
        component.show(!this.hidden);
    }

    public Object get(String string) {
        if ("disabled".equals(string)) {
            return new Boolean(this.disabled);
        }
        if ("hidden".equals(string)) {
            return new Boolean(this.hidden);
        }
        if ("foreColor".equals(string)) {
            return this.foreColor;
        }
        if ("backColor".equals(string)) {
            return this.backColor;
        }
        if ("fontName".equals(string)) {
            return this.fontName;
        }
        if ("fontSize".equals(string)) {
            return new Integer(this.fontSize);
        }
        if ("fontBold".equals(string)) {
            return new Boolean(this.fontBold);
        }
        if ("fontItalic".equals(string)) {
            return new Boolean(this.fontItalic);
        }
        if ("radio".equals(string)) {
            return this.radio;
        }
        if ("status".equals(string)) {
            return this.status;
        }
        return null;
    }

    public synchronized void set(Object object, String string) {
        this.set(this.component, object, string);
    }

    protected void set(Component component, Object object, String string) {
        Object object2;
        if ("disabled".equals(string)) {
            boolean bl = TypeConverter.toBoolean(object);
            if (bl != this.disabled) {
                this.disabled = bl;
                if (component == null) {
                    this.repaint();
                    return;
                }
                component.enable(!this.disabled);
            }
            return;
        }
        if ("hidden".equals(string)) {
            boolean bl = TypeConverter.toBoolean(object);
            if (bl != this.hidden) {
                this.hidden = bl;
                if (component == null) {
                    this.repaint();
                    return;
                }
                if (this.hidden) {
                    component.hide();
                    return;
                }
                this.recreateComponent();
            }
            return;
        }
        if ("foreColor".equals(string)) {
            Object object3 = object == null ? Color.black : (object2 = object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
            if (object2 == null) {
                object2 = Color.black;
            }
            if (!((Color)object2).equals(this.foreColor)) {
                this.foreColor = object2;
                if (component == null) {
                    this.repaint();
                } else if (!this.hidden) {
                    this.recreateComponent();
                }
            }
        }
        if ("backColor".equals(string)) {
            Object object4 = object == null ? Color.black : (object2 = object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
            if (object2 == null) {
                object2 = Color.white;
            }
            if (!((Color)object2).equals(this.backColor)) {
                this.backColor = object2;
                if (component == null) {
                    this.repaint();
                    return;
                }
                if (!this.hidden) {
                    this.recreateComponent();
                }
            }
            return;
        }
        if ("fontName".equals(string)) {
            Object object5 = object == null ? "" : (object2 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!((String)object2).equals(this.fontName)) {
                this.fontName = object2;
                if (component == null) {
                    this.repaint();
                    return;
                }
                component.setFont(this.createFont());
            }
            return;
        }
        if ("fontSize".equals(string)) {
            int n = TypeConverter.toInteger(object);
            if (n != this.fontSize) {
                this.fontSize = n;
                if (component == null) {
                    this.repaint();
                    return;
                }
                this.recreateComponent();
            }
            return;
        }
        if ("fontBold".equals(string)) {
            boolean bl = TypeConverter.toBoolean(object);
            if (bl != this.fontBold) {
                this.fontBold = bl;
                if (component == null) {
                    this.repaint();
                    return;
                }
                component.setFont(this.createFont());
            }
            return;
        }
        if ("fontItalic".equals(string)) {
            boolean bl = TypeConverter.toBoolean(object);
            if (bl != this.fontItalic) {
                this.fontItalic = bl;
                if (component == null) {
                    this.repaint();
                    return;
                }
                component.setFont(this.createFont());
            }
            return;
        }
        if ("radio".equals(string)) {
            this.radio = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            return;
        }
        if ("status".equals(string)) {
            Object object6 = object == null ? "" : (object2 = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
            if (!((String)object2).equals(this.status)) {
                this.status = object2;
                if (this.entered) {
                    this.mouseEnter(null, 0, 0);
                }
            }
            return;
        }
    }

    void event() {
        this.event(null);
    }

    void event(String string) {
        VarMonitor.radio(this);
        TraceMonitor.event(this.getName());
        TraceMonitor.eventGo(string);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.entered = true;
        if (this.component == null) {
            this.repaint();
        }
        if (!this.hidden) {
            String string = this.status;
            if (string == null) {
                string = this.getName();
            }
            if (string == null) {
                string = "MathAid";
            }
            if (string != null) {
                TraceMonitor.event("<*ST*>" + string);
            }
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.entered = false;
        if (this.component == null) {
            this.repaint();
        }
        if ("" != null) {
            TraceMonitor.event("<*ST*>");
        }
        return true;
    }

    Font createFont() {
        int n = 0;
        if (this.fontBold) {
            n |= 1;
        }
        if (this.fontItalic) {
            n |= 2;
        }
        return new Font(this.fontName, n, this.fontSize);
    }

    Color getBrighterColor(Color color) {
        if (Toolkit.getDefaultToolkit().getColorModel().getPixelSize() < 16) {
            return color;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n += n >> 1;
        n2 += n2 >> 1;
        n3 += n3 >> 1;
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }
}

