/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import tools.ActivePoint;
import tools.Areas;
import tools.Axes;
import tools.BaseApplet;
import tools.Curve;
import tools.Dot;
import tools.Formula;
import tools.Fraction;
import tools.GraphXYDesc;
import tools.Line;
import tools.Marker;
import tools.TraceMonitor;
import tools.TypeConverter;
import tools.VarMonitor;
import tools.XY;

public final class GraphXY
extends BaseApplet {
    private static boolean Sun = System.getProperty("java.vendor").indexOf("Sun") != -1;
    private static boolean Netscape = System.getProperty("java.vendor").indexOf("Netscape") != -1;
    private static boolean Mac = System.getProperty("os.name").indexOf("Mac") != -1;
    String desc;
    GraphXYDesc gd;
    public Color backColor = Color.white;
    public Color bordColor = Color.black;
    public Axes xAxes = new Axes();
    public Axes yAxes = new Axes();
    Marker activeMarker;
    public ActivePoint activePoint = new ActivePoint();
    XY dragAnchor = new XY();
    int w;
    int h;
    double xs;
    double ys;
    Image staticImage;
    Graphics staticImageGraphics;
    Image offscreenImage;
    Graphics offscreenImageGraphics;
    Graphics appletGraphics;
    int eventsCount;
    public Vector curves = new Vector();
    public Vector markers = new Vector();
    public Vector fractions = new Vector();
    public Vector formulas = new Vector();
    public Vector lines = new Vector();
    public Vector dots = new Vector();
    public Areas areas = new Areas();
    String pStatus = "";
    boolean entered;

    void clearAllVectors() {
        this.curves.removeAllElements();
        this.markers.removeAllElements();
        this.fractions.removeAllElements();
        this.formulas.removeAllElements();
        this.lines.removeAllElements();
        this.dots.removeAllElements();
        this.areas.removeAllElements();
    }

    void doRegister(boolean bl) {
        String string = this._getDocPath();
        int n = 0;
        while (n < this.markers.size()) {
            Marker marker = (Marker)this.markers.elementAt(n);
            marker.parent = this;
            VarMonitor.register(string, marker, this, bl);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.fractions.size()) {
            Fraction fraction = (Fraction)this.fractions.elementAt(n2);
            fraction.parent = this;
            VarMonitor.register(string, fraction, this, bl);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.formulas.size()) {
            Formula formula = (Formula)this.formulas.elementAt(n3);
            formula.parent = this;
            VarMonitor.register(string, formula, this, bl);
            ++n3;
        }
    }

    public void init() {
        super.init();
        try {
            this.w = Integer.valueOf(this.getParameter("width"));
            this.h = Integer.valueOf(this.getParameter("height"));
        }
        catch (NumberFormatException numberFormatException) {}
        this.desc = null;
        try {
            this.desc = this.getParameter("desc");
            if (this.desc == null) {
                this.desc = this.getParameter("name");
            }
            if (this.desc.startsWith("/")) {
                this.desc = this.desc.substring(1, this.desc.length() - 5).replace('/', '.');
            } else {
                String string = this._getBasesOffset();
                this.desc = String.valueOf(string.replace('/', '.')) + this.desc;
            }
            this.gd = (GraphXYDesc)Class.forName(this.desc).newInstance();
            this.gd.set(this);
        }
        catch (Exception exception) {
            System.out.println("Bad graph descriptor <" + this.desc + ">");
            return;
        }
        this.backColor = TypeConverter.parseColor(this.getParameter("backColor"), this.backColor);
        this.bordColor = TypeConverter.parseColor(this.getParameter("bordColor"), this.bordColor);
    }

    public void resize(int n, int n2) {
        super.resize(this.w, this.h);
    }

    void doInit() {
        super.doInit();
        if (this.gd == null) {
            return;
        }
        this.offscreenImage = this.createImage(this.w, this.h);
        this.offscreenImageGraphics = this.offscreenImage.getGraphics();
        this.appletGraphics = this.getGraphics();
        this.clearAllVectors();
        try {
            this.gd.graphInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initMarkers();
    }

    void doDestroy() {
        if (this.appletGraphics != null) {
            this.appletGraphics.dispose();
            this.appletGraphics = null;
        }
        if (this.offscreenImageGraphics != null) {
            this.offscreenImageGraphics.dispose();
            this.offscreenImageGraphics = null;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        if (this.staticImage != null) {
            this.staticImage.flush();
            this.staticImage = null;
        }
    }

    void doRun() {
        if (this.gd == null) {
            return;
        }
        boolean bl = this.desc.indexOf("Graph", this.desc.lastIndexOf("/") + 1) != -1;
        Thread thread = Thread.currentThread();
        if (!bl) {
            thread.setPriority(1);
        }
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        int n2 = 0;
        while (thread == this.thread) {
            try {
                this.gd.graphLoop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object object = this.initMutex;
            synchronized (object) {
                if (this.offscreenImage == null) {
                    Object var8_16 = null;
                    return;
                }
                if (this.staticImage != null) {
                    this.offscreenImageGraphics.drawImage(this.staticImage, 0, 0, null);
                } else {
                    Graphics graphics = this.offscreenImageGraphics;
                    graphics.setColor(this.backColor);
                    graphics.fillRect(0, 0, this.w - 1, this.h - 1);
                    graphics = this.offscreenImageGraphics;
                    graphics.setColor(this.bordColor);
                    graphics.drawRect(0, 0, this.w - 1, this.h - 1);
                    if (bl2) {
                        boolean bl4 = this.areMarkersLoaded(false);
                        bl2 = this.draw(this.offscreenImageGraphics, false);
                        if (bl2 && bl4) {
                            this.staticImage = this.createImage(this.w, this.h);
                            this.staticImageGraphics = this.staticImage.getGraphics();
                            this.staticImageGraphics.drawImage(this.offscreenImage, 0, 0, null);
                            this.staticImageGraphics.dispose();
                            this.staticImageGraphics = null;
                        }
                    }
                }
                if (TraceMonitor.getShow()) {
                    bl3 = this.draw(this.offscreenImageGraphics, true);
                }
                this.appletGraphics.drawImage(this.offscreenImage, 0, 0, null);
            }
            this.snapMarkers();
            this.outStatus();
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (!bl) {
                int n3 = 0;
                while (n3 < 10) {
                    Thread.yield();
                    ++n3;
                }
            }
            if (bl2 && this.staticImage == null || !this.areMarkersLoaded(true)) continue;
            if (!bl3) break;
            Object object2 = TraceMonitor.eventsCountMutex;
            synchronized (object2) {
                while (true) {
                    if (thread != this.thread) {
                        Object var8_17 = null;
                        return;
                    }
                    int n4 = TraceMonitor.eventsCount;
                    int n5 = this.eventsCount;
                    if (n4 != n || n5 != n2) break;
                    try {
                        TraceMonitor.eventsCountMutex.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        Object var8_18 = null;
                        return;
                    }
                }
                n = TraceMonitor.eventsCount;
                n2 = this.eventsCount;
            }
            try {
                this.gd.graphLoop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void incEventsCount() {
        Object object = TraceMonitor.eventsCountMutex;
        synchronized (object) {
            ++this.eventsCount;
            TraceMonitor.eventsCountMutex.notifyAll();
            return;
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (Sun) {
            if (this.offscreenImage != null) {
                graphics.setClip(0, 0, this.w, this.h);
                graphics.drawImage(this.offscreenImage, 0, 0, null);
                return;
            }
        } else {
            this.incEventsCount();
        }
    }

    boolean draw(Graphics graphics, boolean bl) {
        boolean bl2 = false;
        Axes.auto(this);
        this.xs = this.w > 3 ? (this.xAxes.end - this.xAxes.beg) / (double)(this.w - 3) : 0.0;
        this.ys = this.h > 3 ? (this.yAxes.end - this.yAxes.beg) / (double)(this.h - 3) : 0.0;
        boolean bl3 = false;
        int n = 0;
        while (n < this.curves.size()) {
            Curve curve = (Curve)this.curves.elementAt(n);
            if (curve.dynamic) {
                bl3 = true;
            }
            if (!(bl ^ curve.dynamic)) {
                curve.calc(this.gd);
                bl2 = true;
            }
            ++n;
        }
        if (!(bl ^ bl3) && !this.areas.isEmpty()) {
            this.areas.drawAreas(graphics, this);
        }
        int n2 = 0;
        while (n2 < this.curves.size()) {
            Curve curve = (Curve)this.curves.elementAt(n2);
            if (!(bl ^ curve.dynamic)) {
                curve.fill(graphics, this.gd);
                bl2 = true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.curves.size()) {
            Curve curve = (Curve)this.curves.elementAt(n3);
            if (!(bl ^ curve.dynamic)) {
                curve.draw(graphics);
                bl2 = true;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.lines.size()) {
            Line line = (Line)this.lines.elementAt(n4);
            if (!(bl ^ line.dynamic)) {
                line.draw(graphics, this);
                bl2 = true;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.dots.size()) {
            Dot dot = (Dot)this.dots.elementAt(n5);
            if (!(bl ^ dot.dynamic)) {
                dot.draw(graphics, this);
                bl2 = true;
            }
            ++n5;
        }
        if (!(bl ^ this.xAxes.dynamic)) {
            this.xAxes.drawXAxesTicks(graphics, this);
            bl2 = true;
        }
        if (!(bl ^ this.yAxes.dynamic)) {
            this.yAxes.drawYAxesTicks(graphics, this);
            bl2 = true;
        }
        if (!(bl ^ this.xAxes.dynamic)) {
            this.xAxes.drawXAxes(graphics, this);
            bl2 = true;
        }
        if (!(bl ^ this.yAxes.dynamic)) {
            this.yAxes.drawYAxes(graphics, this);
            bl2 = true;
        }
        if (Mac && Netscape) {
            int n6 = 0;
            while (n6 < this.markers.size()) {
                Marker marker = (Marker)this.markers.elementAt(n6);
                if (marker.image != null && !(bl ^ marker.dynamic)) {
                    marker.draw(graphics, this);
                    bl2 = true;
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < this.markers.size()) {
                Marker marker = (Marker)this.markers.elementAt(n7);
                if (marker.image == null && !(bl ^ marker.dynamic)) {
                    marker.draw(graphics, this);
                    bl2 = true;
                }
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.fractions.size()) {
                Fraction fraction = (Fraction)this.fractions.elementAt(n8);
                if (!(bl ^ fraction.dynamic)) {
                    fraction.draw(graphics, this);
                    bl2 = true;
                }
                ++n8;
            }
            int n9 = 0;
            while (n9 < this.formulas.size()) {
                Formula formula = (Formula)this.formulas.elementAt(n9);
                if (!(bl ^ formula.dynamic)) {
                    formula.draw(graphics, this, 0, 0);
                    bl2 = true;
                }
                ++n9;
            }
        } else {
            int n10 = 0;
            while (n10 < this.fractions.size()) {
                Fraction fraction = (Fraction)this.fractions.elementAt(n10);
                if (!(bl ^ fraction.dynamic)) {
                    fraction.draw(graphics, this);
                    bl2 = true;
                }
                ++n10;
            }
            int n11 = 0;
            while (n11 < this.formulas.size()) {
                Formula formula = (Formula)this.formulas.elementAt(n11);
                if (!(bl ^ formula.dynamic)) {
                    formula.draw(graphics, this, 0, 0);
                    bl2 = true;
                }
                ++n11;
            }
            int n12 = 0;
            while (n12 < this.markers.size()) {
                Marker marker = (Marker)this.markers.elementAt(n12);
                if (!(bl ^ marker.dynamic)) {
                    marker.draw(graphics, this);
                    bl2 = true;
                }
                ++n12;
            }
        }
        if (!(bl ^ this.activePoint.dynamic)) {
            this.activePoint.draw(graphics, this);
            bl2 = true;
        }
        graphics.setColor(this.bordColor);
        graphics.drawRect(0, 0, this.w - 1, this.h - 1);
        return bl2;
    }

    void drawBack(Graphics graphics) {
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, this.w - 1, this.h - 1);
    }

    void drawBorder(Graphics graphics) {
        graphics.setColor(this.bordColor);
        graphics.drawRect(0, 0, this.w - 1, this.h - 1);
    }

    XY Point2XY(Point point) {
        double d = this.xAxes.beg + (double)(-1 + point.x) * this.xs;
        double d2 = this.yAxes.beg + (double)(this.h - 2 - point.y) * this.ys;
        return new XY(d, d2);
    }

    Point XY2Point(XY xY) {
        int n = 1 + (int)((xY.x - this.xAxes.beg) / this.xs + 0.5);
        int n2 = this.h - 2 - (int)((xY.y - this.yAxes.beg) / this.ys + 0.5);
        return new Point(n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Marker marker = null;
        int n3 = 0;
        while (n3 < this.markers.size()) {
            Marker marker2 = (Marker)this.markers.elementAt(n3);
            if (marker2.dynamic && !marker2.hidden && !marker2.disabled && marker2.rect != null && (marker2.draggable || marker2.clickable || marker2.selectable) && new Rectangle(n, n2, 1, 1).intersects(marker2.rect)) {
                marker = marker2;
            }
            ++n3;
        }
        if (this.activeMarker != marker) {
            this.incEventsCount();
        }
        this.activeMarker = marker;
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.activePoint.p.x = n;
        this.activePoint.p.y = n2;
        this.activePoint.active = true;
        this.dragAnchor = this.Point2XY(this.activePoint.p);
        if (this.activeMarker != null) {
            this.activeMarker.pressed = true;
        }
        this.incEventsCount();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.activePoint.active = false;
        if (this.activeMarker != null) {
            this.activeMarker.pressed = false;
            this.activeMarker.click();
        }
        this.incEventsCount();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.w - 2) {
            n = this.w - 2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > this.h - 1) {
            n2 = this.h - 1;
        }
        Point point = new Point(n, n2);
        XY xY = this.Point2XY(point);
        if (this.activeMarker != null && this.activeMarker.draggable) {
            this.activeMarker.ax += xY.x - this.dragAnchor.x;
            this.activeMarker.ay += xY.y - this.dragAnchor.y;
            this.dragAnchor.x = xY.x;
            this.dragAnchor.y = xY.y;
            this.activeMarker.dragged = true;
        }
        this.activePoint.p.x = n;
        this.activePoint.p.y = n2;
        this.incEventsCount();
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.entered = true;
        this.incEventsCount();
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.entered = false;
        this.activeMarker = null;
        if ("" != null) {
            TraceMonitor.event("<*ST*>");
        }
        this.pStatus = "";
        this.incEventsCount();
        return true;
    }

    void initMarkers() {
        int n = 0;
        while (n < this.markers.size()) {
            Marker marker = (Marker)this.markers.elementAt(n);
            marker.ax = marker.x;
            marker.ay = marker.y;
            ++n;
        }
    }

    void snapMarkers() {
        int n = 0;
        while (n < this.markers.size()) {
            Marker marker = (Marker)this.markers.elementAt(n);
            marker.x = marker.ax;
            marker.y = marker.ay;
            if (marker.dragged) {
                marker.dragged = false;
                if (marker.draggable) {
                    TraceMonitor.event(marker.name);
                }
            }
            ++n;
        }
    }

    boolean areMarkersLoaded(boolean bl) {
        int n = 0;
        while (n < this.markers.size()) {
            Marker marker = (Marker)this.markers.elementAt(n);
            if (!marker.isLoaded(bl)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void outStatus() {
        if (!this.entered) {
            return;
        }
        String string = null;
        if (this.activeMarker != null && (string = this.activeMarker.status) == null) {
            string = this.activeMarker.name;
        }
        if (string == null) {
            string = this.getParameter("status");
        }
        if (string == null) {
            string = this.getParameter("desc");
        }
        if (string == null) {
            string = this.getParameter("name");
        }
        if (string == null) {
            string = "MathAid";
        }
        if (!this.pStatus.equals(string)) {
            if (string != null) {
                TraceMonitor.event("<*ST*>" + string);
            }
            this.pStatus = string;
        }
    }
}

