@echo off
REM
REM Assume we're just tidying up if there is a 3rd parameter.
REM (Parameter is set to OFF when finished.)
REM
if not x%3 == x goto makeindex
REM
REM If parameter number 2 = ARCHIVE then save the old JPG files.
REM Otherwise, just delete them.
REM
if x%2 == xARCHIVE goto archive
del image*.jpg
goto :skiparc
:archive
if not exist archive\nul mkdir archive
move image*.jpg archive
:skiparc
REM
REM Convert the large JPEG file to a more manageable size
REM and do a little gamma correction at the same time.
REM Delete the large JPEG when the conversion is done.
REM
REM Notes on the image conversion:
REM -q 65 is the jpeg compression value. Increase this value, (anything up to 100),
REM to get higher quality images, (but also larger file sizes).
REM -gamma 1.6 sets the gamma correction factor to 1.3. Increase this value, 
REM (up to 5), for brighter images.
REM -resize 576 432 sets the width/height t0 576/432. This is half the original size.
REM Increase or decrease these values as you see fit.
REM 
REM nconvert -help
REM   - prints a full list of the conversion options that can be used with nconvert
REM
nconvert -quiet -in 0 -out 0 -o image%1.jpg -q 65 -gamma 1.6 -resize 576 432 input.jpg
REM del input.jpg
REM
REM Create the INDEX.HTML file
REM Its patched together from the following:
REM TOP.TXT (or TOPOFF.TXT when parameter number 3 is set to OFF)
REM IMAGEFILENAME.JPG
REM MIDDLE.TXT
REM MESSAGE.TXT
REM BOTTOM.TXT
REM
:makeindex
type top%3.txt > index.html
echo SRC="image%1.jpg" >> index.html
if exist middle.txt type middle.txt >> index.html
if exist message.txt type message.txt >> index.html
type bottom.txt >> index.html
REM
REM Update the INDEX.HTML file in the ARCHIVE directory
REM if a 3rd parameter has been specified.
REM (Parameter is set to OFF when finished.)
REM
if x%3 == x goto finished
if not exist archive\nul mkdir archive
imglist
:finished
