/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.GenericAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import rogatkin.HttpUtils;

public class Address
extends GenericAttribute {
    protected String city;
    protected String state;
    protected String country;
    protected String zip;
    protected String title;

    Address(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, string6);
        this.city = this.assignWithDefault(string2);
        this.state = this.assignWithDefault(string3);
        this.country = this.assignWithDefault(string4);
        this.zip = this.assignWithDefault(string5);
        this.title = this.assignWithDefault(string7);
    }

    String getFormated() {
        return this.value + '\n' + this.city + ", " + this.state + ' ' + this.zip + (this.country.length() > 0 ? ", " : "") + this.country;
    }

    public void saveXML(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        outputStream.write(("<ADDRESS ORDER=\"" + n + "\"  TYPE=\"OTHER\" COMMENT=\"").getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.description).getBytes(string));
        outputStream.write("\">".getBytes(string));
        outputStream.write("<TITLE>".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.title).getBytes(string));
        outputStream.write("</TITLE>".getBytes(string));
        outputStream.write("<STREET>".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.value).getBytes(string));
        outputStream.write("</STREET>".getBytes(string));
        outputStream.write("<CITY>".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.city).getBytes(string));
        outputStream.write("</CITY>".getBytes(string));
        outputStream.write("<STATE>".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.state).getBytes(string));
        outputStream.write("</STATE>".getBytes(string));
        outputStream.write("<COUNTRY>".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.country).getBytes(string));
        outputStream.write("</COUNTRY>".getBytes(string));
        outputStream.write("<ZIP>".getBytes(string));
        outputStream.write(this.zip.getBytes(string));
        outputStream.write("</ZIP>".getBytes(string));
        outputStream.write("</ADDRESS>".getBytes(string));
    }
}

